(ns io.dominic.rich-crdt.lww-register
  (:require
    [io.dominic.rich-crdt.protocols :as p]))

(declare ->LWWRegister)

(deftype LWWRegister [add remove ts ^java.util.Comparator comp]
  p/ICRDTCollection
  (cons [this crdt-entry]
    (let [[[k v] t] crdt-entry]
      (if (and
            (contains? ts k)
            (>= (.compare comp (get ts k) t) 0))
        this
        (->LWWRegister (assoc add k v)
                       (disj remove k)
                       (assoc ts k t)
                       comp))))
  (disj [this k-t]
    (let [[k t] k-t]
      (if (and
            (contains? ts k)
            (>= (.compare comp (get ts k) t) 0))
        this
        (->LWWRegister (dissoc add k)
                       (disj remove k)
                       (assoc ts k t)
                       comp))))
  (cseq [this] (map (fn [x] [x (get ts (first x))]) add))
  (dseq [this] (map #(find ts %) remove)))

(defmethod print-method LWWRegister [lwwes ^java.io.Writer w]
  (.write w "#io.dominic.rich-crdt/lww-register[")
  (print-method (.-add lwwes) w)
  (.write w " ") (print-method (.-remove lwwes) w)
  (.write w " ") (print-method (.-ts lwwes) w)
  (.write w "]"))

(defmethod print-dup LWWRegister [lwwes w] (print-method lwwes w))

(defn lww-register
  [& crdt-entrys]
  (->LWWRegister (into {} (map first crdt-entrys))
                 #{}
                 (into {} (map #(update % 0 first) crdt-entrys))
                 compare))

(defn- read-lww-register
  [[add remove ts]]
  (->LWWRegister add remove ts compare))

(defn lww-register-by
  [comp & crdt-entrys]
  (->LWWRegister (into {} (map first crdt-entrys))
                 #{}
                 (into {} (map #(update % 0 first) crdt-entrys))
                 comp))

(defn with-comparator
  [lww-element-set comp]
  (->LWWRegister (.-add lww-element-set) (.-remove lww-element-set) (.-ts lww-element-set) comp))

(defn ->clj
  [lww-element-set]
  (.-add lww-element-set))

(deftype ClojureMap [^LWWRegister crdt update-at m]
  clojure.lang.IPersistentMap
  (assoc [_ k v]
    (assert update-at "Must set update-at before making changes to LWWRegister ClojureMap")
    (let [nv (p/cons crdt [[k v] update-at])]
      (ClojureMap. nv update-at (->clj nv))))
  ;; assocEx
  (without [_ k]
    (assert update-at "Must set update-at before making changes to LWWRegister ClojureMap")
    (let [nv (p/disj crdt [k update-at])]
      (ClojureMap. nv update-at (->clj nv))))

  java.lang.Iterable
  (iterator [this]
    (.iterator ^java.lang.Iterable m))
  
  clojure.lang.IPersistentCollection
  (count [this]
    (count m))
  (cons [^clojure.lang.IPersistentMap this o]
    (cond
      (instance? java.util.Map$Entry o)
      (let [^java.util.Map$Entry e o]
        (.assoc this (.getKey e) (.getValue e)))
      (vector? o)
      (if (= 2 (count o))
        (throw (IllegalArgumentException. "Vector arg to map conj must be a pair"))
        (.assoc this (nth o 0) (nth o 1)))
      :else
      (reduce #(.assoc %1 (.getKey %2) (.getValue %2)) this o)))
  (empty [this] (ClojureMap. (->LWWRegister {} #{} (.-comp crdt)) update-at {}))
  (equiv [this o] (.equiv m o))
  (seq [this] (seq m))
  clojure.lang.ILookup
  (valAt [this o] (.valAt ^clojure.lang.ILookup m o))
  (valAt [this o o1] (.valAt ^clojure.lang.ILookup m o o1))
  clojure.lang.Associative
  (containsKey [this o] (.containsKey ^clojure.lang.Associative m o))
  (entryAt [this o] (.entryAt ^clojure.lang.Associative m o))
  Object
  (equals [this obj] (.equals m obj))
  (hashCode [this] (.hashCode m))
  (toString [this] (.toString m))

  clojure.lang.IFn
  (invoke [this o] (.invoke ^clojure.lang.IFn m o))
  (invoke [this o o1] (.invoke ^clojure.lang.IFn m o o1))
  (applyTo [this arglist] (apply m arglist))

  clojure.lang.IHashEq
  (hasheq [this] (.hasheq ^clojure.lang.IHashEq m)))

(defn ->clj-map
  ([crdt] (->ClojureMap crdt nil (->clj crdt)))
  ([crdt update-at] (->ClojureMap crdt update-at (->clj crdt))))

(defn update-at
  [^ClojureMap clj-map update-at]
  (->ClojureMap (.-crdt clj-map) update-at (.-m clj-map)))

(defn clj-map->crdt
  [^ClojureMap clj-map]
  (.-crdt clj-map))

(comment (-> (lww-register)
             (->clj-map)
             (update-at 10)
             (assoc :foo 10)
             (update-at 20)
             (assoc :foo 20)
             (update-at 19)
             (dissoc :foo)
             (update-at 50)
             (merge {:a "wooohooo"
                     :b "yeah boi"})
             #_(clj-map->crdt)
             #_(prn)))
