(ns io.dominic.rich-crdt.core
  (:require
    [io.dominic.rich-crdt.protocols :as p]
    [io.dominic.rich-crdt.lww-element-set :refer [lww-element-set]])
  (:refer-clojure :rename {conj core-conj
                           disj core-disj
                           merge core-merge}))

(defn conj
  "conj to element set at time"
  ([] (lww-element-set))
  ([crdt-coll] crdt-coll)
  ([crdt-coll crdt-entry & crdt-entrys]
   #_(let [es-coll (update crdt-coll ::add (fnil core-conj {}) (max-by-key second (get-comp es-coll) [x t] (find (::add es-coll) x)))]
       (if xs
         (recur es-coll t (first xs) (next xs))
         es-coll))
   (if crdt-entrys
     (recur (p/cons crdt-coll crdt-entry) (first crdt-entrys) (next crdt-entrys))
     (p/cons crdt-coll crdt-entry))))

(defn disj
  "disj[oin].  Returns a new lwwes with elements removed."
  ([crdt-coll] crdt-coll)
  ([crdt-coll crdt-entry & crdt-entrys]
   #_(let [es-coll (update es-coll ::remove (fnil core-conj {}) (max-by-key second (get-comp es-coll) [x t] (find (::remove es-coll) x)))]
       (if xs
         (recur es-coll t (first xs) (next xs))
         es-coll))
   (if crdt-entrys
     (recur (p/disj crdt-coll crdt-entry) (first crdt-entrys) (next crdt-entrys))
     (p/disj crdt-coll crdt-entry))))

(defn conj-at
  [crdt-coll t & xs]
  (reduce #(conj %1 [%2 t]) crdt-coll xs))

(defn disj-at
  [crdt-coll t & xs]
  (reduce #(disj %1 [%2 t]) crdt-coll xs))

(defn merge
  [& crdt-colls]
  (reduce
    (fn
      ([] nil)
      ([acc crdt-coll]
       (as-> acc %
         (apply conj % (p/cseq crdt-coll))
         (apply disj % (p/dseq crdt-coll)))))
    crdt-colls))

(comment
  (require '[io.dominic.rich-crdt.lww-element-set :as lwwes])

  (lwwes/->clj (merge (-> (conj-at (conj) 10 :a :b :c)
                          (disj-at 9 :a)
                          (disj-at 11 :c))
                      (-> (conj-at (lwwes/lww-element-set) 12 :d)
                          (conj-at 9 :a)
                          (disj-at 11 :b))))
  (lwwr/->clj (-> (lwwr/lww-register-by (java.text.Collator/getInstance)
                                    [[:a 1] "10"]
                                    [[:b 2] "20"])
                  (conj [[:a 2] "20"])))
  (require '[io.dominic.rich-crdt.lww-register :as lwwr])
  (lwwr/->clj (merge (-> (conj-at (lwwr/lww-register) 10 [:a "val"] [:b "val"] [:c "value"])
                         (disj-at 9 :a)
                         (disj-at 11 :c))
                     (-> (conj-at (lwwes/lww-element-set) 12 [:d "val"] [:a "newval"])
                         (conj-at 9 [:a "oldval"])
                         (disj-at 15 :b))))
  )
