(ns io.dominic.wedge.clip-aero
  "Wedge-compatible :system for clip/aero.  Example system_config.edn:
    * {:system io.dominic.wedge.clip-aero}
    * {:system io.dominic.wedge.clip-aero
       :key :clip/system}

  Uses aero to read `config.edn`, and gets the system from it.

  Requires `aero` and `clip` to be on the classpath.

  See [[system-config]] for supported options."
  (:require
    [juxt.clip.core :as clip]
    [io.dominic.wedge.impl.aero :as impl.aero]))

(defn get-config
  "Opts is a map with valid keys:
     :io.dominic.wedge.aero/tag-ns - a list of symbols to be required prior to reading.  Use this to load any namespaces containing Aero tags."
  [opts]
  (impl.aero/config opts))

(defn start
  "Optional opts:
     :key - the key in config which contains the clip system.  Defaults to
            :clip/system."
  [config {:keys [key] :or {key :clip/system}}]
  (let [system-conf (get config key)]
    (vary-meta (clip/start system-conf) assoc ::system-conf system-conf)))

(defn stop
  [system]
  (let [{::keys [system-conf]} (meta system)]
    (clip/stop system-conf system)))

(defn load-dev
  []
  (load "/io/dominic/wedge/impl/clip_aero_dev"))
