(ns io.dominic.wedge.compile
  (:require
    [clojure.edn :as edn]
    [io.dominic.wedge.system :as wedge.system]))

(defn- read-args
  [args]
  (mapv
    #(try
       (edn/read-string {:default tagged-literal} %)
       (catch Throwable t
         (throw (ex-info (str "Unreadable arg: " (pr-str %)) {:arg %} t))))
    args))

(defn- parse-args
  [args]
  (when (odd? (count args))
    (throw (ex-info (format "Odd number of arguments provided (%d), cannot convert to map" (count args))
                    {:args args})))
  (reduce
    (fn [acc [k v]]
      (if (sequential? k)
        (assoc-in acc k v)
        (assoc acc k v)))
    {}
    (partition-all 2 args)))

(defn -main
  [& args]
  (let [opts (parse-args (read-args args))]
    (binding [*compile-files* true]
      (require 'clojure.edn 'io.dominic.wedge.system :reload-all)
      (wedge.system/load-system (wedge.system/get-config opts) opts))))
