(ns io.dominic.wedge.dev
  "Functions commonly used from a `dev` namespace.  Recommended usage is like:
  ```
  (ns dev
    (:require [io.dominic.wedge.dev :refer :all]))
  ```"
  (:require
    [clojure.java.io :as io]
    [io.dominic.wedge.impl.dev-system-hooks :as impl.dev-system-hooks]
    [io.dominic.wedge.impl.dev-tooling :as impl.dev-tooling]
    [io.dominic.wedge.system :as wedge.system]))

(try
  (wedge.system/load-dev)
  (catch clojure.lang.ExceptionInfo e
    (let [data (ex-data e)]
      (if (= ::wedge.system/missing-ns (::wedge.system/type data))
        (throw (Exception. (format "Unable to locate '%s', either you're missing a dependency, or :system is set incorrectly in system_config.edn"
                                   (::wedge.system/namespace data))))
        (throw e)))))

(def cljs?
  (try
    (require 'cljs.main)
    true
    (catch java.io.FileNotFoundException _
      false)))

(defn generate-tooling
  ([] (generate-tooling ["dev"]))
  ([clj-aliases]
   (spit ".dir-locals.el"
         (impl.dev-tooling/dir-locals (map name clj-aliases) cljs?))
   (spit (doto ".vscode/settings.json" io/make-parents)
         (impl.dev-tooling/calva-settings-json (map name clj-aliases) cljs?))))

(defn ^:private infect
  [old-var new-var]
  (doto new-var
    (alter-var-root (constantly @old-var))
    (alter-meta! merge (meta old-var))))

;; TODO: make more doc-friendly using defn to wrap
(infect #'impl.dev-system-hooks/add-dev-system-fixture!
        (def add-dev-system-fixture!))
(infect #'impl.dev-system-hooks/remove-dev-system-fixture!
        (def remove-dev-system-fixture!))
