(ns io.dominic.wedge.fern
  "Wedge-compatible :config for fern.  Example system_config.edn:
    * `{:config io.dominic.wedge.fern}`

  Uses fern.easy to read `config.fern`, and uses fern/evaluate to get
  references from it.  Keywords are converted to symbols when grabbed from the config, for example `:ig/system` will be gotten as `ig/system`.

  Requires `fern` to be on the classpath.

  If integrant is on the classpath, `:ig/ref` and `:ig/refset` are added as
  literals to fern which call their respective integrant functions.

  See [[read]] for supported options."
  (:refer-clojure :exclude [get read])
  (:require
    [clojure.java.io :as io]
    fern
    fern.easy))

(when (try (require 'integrant.core) true
           (catch Exception _ nil))
  (let [igref @(resolve 'integrant.core/ref)
        igrefset @(resolve 'integrant.core/refset)]
    (defmethod fern/literal :ig/ref [_ value]
      (igref value))
    (defmethod fern/literal :ig/refset [_ value]
      (igrefset value))))

(defn read
  "::plugin-symbols and ::path will be passed to fern.easy/load."
  [{::keys [plugin-symbols path]
    :or {plugin-symbols '[plugins]
         path "config.fern"}}]
  (locking clojure.lang.RT/REQUIRE_LOCK
    (fern.easy/load (io/reader path) path plugin-symbols)))

(defn get
  [config k]
  (fern/evaluate config (symbol k)))
