(ns io.dominic.wedge.integrant
  "Wedge-compatible :system for integrant.  Example system_config.edn:
    * {:system io.dominic.wedge.integrant}
    * {:system io.dominic.wedge.integrant
       :key :integrant/system}

  Requires `integrant` to be on the classpath, and for dev also requires
  `integrant/repl`.

  Runs `ig/prep` and `ig/load-namespaces` as part of the start process.

  See [[system-config]] for supported options."
  (:refer-clojure :exclude [key])
  (:require
    [integrant.core :as ig]))

(defn ^:no-doc prep
  "WARNING: Implementation detail.  Subject to change."
  [system-config]
  (locking clojure.lang.RT/REQUIRE_LOCK
    (ig/load-namespaces system-config))
  (ig/prep system-config)
  system-config)

(defn start
  "Optional opts:
     :keys - keys to start."
  [system-config opts]
  (let [system-config (prep system-config)]
    (if-let [[_ keys] (find opts :keys)]
      (ig/init system-config keys)
      (ig/init system-config))))

(defn stop
  [system]
  (ig/halt! system))

(defn load-dev
  []
  (load "/io/dominic/wedge/impl/integrant_dev"))

(defn load-system
  [system _opts]
  (locking clojure.lang.RT/REQUIRE_LOCK
    (ig/load-namespaces system)))

(def key :ig/system)
