(ns io.dominic.wedge.system
  (:require
    [clojure.java.io :as io]
    [clojure.edn :as edn]))

(defn read-system-config
  []
  (if-let [r (io/resource "io/dominic/wedge/system-config.edn")]
    (edn/read (java.io.PushbackReader.  (io/reader r)))
    {:system 'io.dominic.wedge.aero-clip
     :dev {:profile :dev}}))

(defn- call-system
  [nm & args]
  (let [config (read-system-config)
        sym (symbol (name (:system config))
                    (name nm))]
    (if-let [f (requiring-resolve sym)]
      (apply f args)
      (throw (ex-info (str "Missing " sym)
                      {:nm nm
                       :config config})))))

(defn system-config
  [opts]
  (call-system 'system-config opts))

(defn start
  [system-conf]
  (call-system 'start system-conf))

(defn stop
  [system]
  (call-system 'stop system))

(defn load-dev
  []
  (call-system 'load-dev))
