(ns io.dominic.wedge.user
  (:require
    [io.dominic.wedge.dev :as wedge.dev]
    [clojure.tools.namespace.repl :as namespace.repl]))

(when (try
        (Class/forName "org.slf4j.bridge.SLF4JBridgeHandler")
        (catch ClassNotFoundException _
          false))
  (eval
    `(do
       (org.slf4j.bridge.SLF4JBridgeHandler/removeHandlersForRootLogger)
       (org.slf4j.bridge.SLF4JBridgeHandler/install))))

(let [lock (Object.)]
  (defn dev
    "Call this to switch to the dev namespace."
    []
    (println "[Wedge] Loading dev")
    (locking lock
      (require 'dev))
    (when-not wedge.dev/system
      (println "[Wedge] Enter (go) to start the system"))
    (in-ns 'dev)))

(defn fixed!
  "If, for some reason, the Clojure code in the project fails to
  compile - we still bring up a REPL to help debug the problem. Once
  the problem has been resolved you can call this function to continue
  development."
  []
  (namespace.repl/refresh-all)
  (in-ns 'dev))

(def refresh namespace.repl/refresh)
(def refresh-all namespace.repl/refresh-all)
