(ns io.dominic.wedge.impl.dev-system-hooks)

(def ^:private fixtures (atom nil))

(defn add-dev-system-fixture!
  [lifecycle key f]
  (swap! fixtures assoc-in [lifecycle key] f)
  :added)

(defn remove-dev-system-fixture!
  [lifecycle key]
  (swap! fixtures update lifecycle dissoc key)
  :removed)

(defn raise-evt
  [lifecycle]
  (run! #(%) (vals (get @fixtures lifecycle))))
