(require '[integrant.repl]
         '[integrant.repl.state]
         '[io.dominic.wedge.impl.dev-system-hooks :as impl.dev-system-hooks])

;; TODO: This is bad really, doesn't allow go to source, etc.
(doseq [[deff ref] (ns-publics 'integrant.repl)
        :let [{:keys [doc arglists]} (meta ref)]]
  ;; TODO: @ref or ref?  I think basically equivalent.
  (alter-meta!
    (intern *ns* deff
            (case deff
              (init go)
              (fn [& args]
                (let [running? (boolean integrant.repl.state/system)
                      ret (apply @ref args)]
                  (impl.dev-system-hooks/raise-evt :start-always)
                  (when (not running?)
                    (impl.dev-system-hooks/raise-evt :start-once))
                  ret))
              (clear halt)
              (fn [& args]
                (let [ret (apply @ref args)]
                  (impl.dev-system-hooks/raise-evt :stop-always)
                  (impl.dev-system-hooks/raise-evt :stop-once)
                  ret))
              suspend
              (fn [& args]
                (let [ret (apply @ref args)]
                  (impl.dev-system-hooks/raise-evt :stop-always)
                  ret))
              resume
              (fn [& args]
                (let [running? (boolean integrant.repl.state/system)
                      ret (apply @ref args)]
                  (impl.dev-system-hooks/raise-evt :start-always)
                  (when (not running?)
                    (impl.dev-system-hooks/raise-evt :start-once))
                  ret))
              reset
              (fn [& args]
                ;; TODO: in other cases this runs before
                ;; stop, but here we do not.
                (impl.dev-system-hooks/raise-evt :stop-always)
                (let [running? (boolean integrant.repl.state/system)
                      ret (apply @ref args)]
                  (impl.dev-system-hooks/raise-evt :start-always)
                  (when (not running?)
                    (impl.dev-system-hooks/raise-evt :start-once))
                  ret))
              @ref))
    assoc
    :doc doc
    :arglists arglists))

(def system integrant.repl.state/system)
(def config integrant.repl.state/config)

(add-watch #'integrant.repl.state/system
           ::dev-sys
           (fn [_ _ _ v]
             (alter-var-root #'system (constantly v))))

(add-watch #'integrant.repl.state/config
           ::dev-conf
           (fn [_ _ _ v]
             (alter-var-root #'config (constantly v))))
