(ns io.dominic.wedge.impl.aero
  (:require
    [clojure.java.io :as io]
    [aero.core :as aero]))

(defn config
  [{:keys [io.dominic.wedge.aero/tag-ns]}]
  (assert (every? symbol? tag-ns) "Must be symbols in tag-ns")
  (when (seq tag-ns)
    (locking clojure.lang.RT/REQUIRE_LOCK
      (apply require tag-ns)))
  (aero/read-config (io/resource "config.edn")))
