(require 'juxt.clip.repl
         '[io.dominic.wedge.impl.dev-system-hooks :as impl.dev-system-hooks])

(defn- hook-fn
  [f1 f2]
  (fn [& args]
    (apply f2 f1 args)))

;; TODO: This is bad, doesn't allow go to source, etc.
(doseq [[deff ref] (ns-publics 'juxt.clip.repl)
        :let [{:keys [doc arglists]} (meta ref)]]
  (if (fn? @ref)
    (alter-meta!
      (intern *ns* deff
              (case deff
                (start go)
                (hook-fn @ref
                         (fn [f]
                           (let [ret (f)]
                             (impl.dev-system-hooks/raise-evt :start-always)
                             (impl.dev-system-hooks/raise-evt :start-once)
                             ret)))
                stop
                (hook-fn @ref
                         (fn [f]
                           (let [ret (f)]
                             (impl.dev-system-hooks/raise-evt :stop-always)
                             (impl.dev-system-hooks/raise-evt :stop-once)
                             ret)))
                (reset reset-all)
                (hook-fn @ref
                         (fn [f]
                           ;; TODO: in other cases this runs before
                           ;; stop, but here we do not.
                           (impl.dev-system-hooks/raise-evt :stop-always)
                           (let [ret (f)]
                             (impl.dev-system-hooks/raise-evt :start-always)
                             (impl.dev-system-hooks/raise-evt :start-once)
                             ret)))
                @ref))
      assoc
      :doc doc
      :arglists arglists)
    (let [lref (intern *ns* deff @ref)]
      (add-watch ref
                 (keyword (str *ns*) (name deff))
                 (fn [_ _ _ v]
                   (alter-var-root lref (constantly v)))))))

;; TODO: Test the failure conditions on this e.g. when (suspend) then (start)
;; or similar.
(def ^:private suspended? (atom false))

(defn suspend
  []
  (let [running? (boolean juxt.clip.repl/system)
        ret (juxt.clip.repl/stop)]
    (reset! suspended? running?)
    (impl.dev-system-hooks/raise-evt :stop-always)
    ret))

(defn resume
  []
  (let [suspended?' @suspended?
        ret (juxt.clip.repl/start)]
    (reset! suspended? false)
    (impl.dev-system-hooks/raise-evt :start-always)
    (when (not suspended?')
      (impl.dev-system-hooks/raise-evt :start-once))
    ret))
