(ns {{namespace}}.app
  (:require
    [io.dominic.helix-sev.core :refer [defnc defnc-]]
    [io.dominic.helix-sev.dom :refer [$d]]
    [helix.hooks :as hooks]
    ["react-dom" :as react.dom]))

(enable-console-print!)

(defnc- greeting
  "A component which greets a user."
  [{:keys [name]}]
  ($d "p.greeting" "Hello, " ($d "em" name) "!"))

(defnc app
  []
  (let [[state set-state] (hooks/use-state {:name "Helix User"})]
    ($d "div"
     ($d "h1" "Welcome!")
      (greeting {:name (:name state)})
      ($d "input" {:value (:name state)
                   :on-change #(set-state assoc :name (.. % -target -value))}))))

(defn mount
 []
 (react.dom/render
   (app)
   (js/document.getElementById "app")))
