(ns clj.new.io.dominic.wedge
  (:require [clj.new.templates :refer [renderer render-text project-data ->files]]
            [io.dominic.wedge.impl.dev-tooling :as impl.dev-tooling]))

(defn wedge
  [name]
  (let [render (renderer "io/dominic/wedge")
        data (project-data name)]
    (println "Generating fresh 'clj new' wedge project.")
    (->files data
             ["README" (render "README" data)]
             [".gitignore" (render "gitignore" data)]
             ["deps.edn" (render "deps.edn" data)]
             ["app.cljs.edn" (render "app.cljs.edn" data)]
             ["min.cljs.edn" (render "min.cljs.edn" data)]
             ["src/{{nested-dirs}}/web.clj" (render "web.clj" data)]
             ["src/{{nested-dirs}}/app.cljs" (render "app.cljs" data)]
             ["src/config.edn" (render "config.edn" data)]
             ["src/io/dominic/wedge/system-config.edn" (render "system-config.edn" data)]
             ["dev/log_dev_app.properties" (render-text "app_root_logger={{namespace}}" data)]
             ["dev/user.clj" (render "user.clj" data)]
             ["dev/dev.clj" (render "dev.clj" data)]
             [".dir-locals.el" (impl.dev-tooling/dir-locals ["dev"] false)]
             [".vscode/settings.json" (impl.dev-tooling/calva-settings-json ["dev"] false)]
             ["target/.gitkeep" ""])))
