/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.actors.connectivity.retry.config;

import io.dropwizard.actors.connectivity.retry.RetryType;
import io.dropwizard.actors.connectivity.retry.config.RetryConfig;
import io.dropwizard.util.Duration;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

public class TimeLimitedFixedWaitRetryConfig
extends RetryConfig {
    @NotNull
    @Valid
    private Duration maxTime = Duration.seconds((long)30L);
    @NotNull
    @Valid
    private Duration waitTime = Duration.milliseconds((long)500L);

    public TimeLimitedFixedWaitRetryConfig() {
        super(RetryType.TIME_LIMITED_FIXED_WAIT);
    }

    public TimeLimitedFixedWaitRetryConfig(Duration maxTime, Duration waitTime) {
        this();
        this.maxTime = maxTime;
        this.waitTime = waitTime;
    }

    public static TimeLimitedFixedWaitRetryConfigBuilder builder() {
        return new TimeLimitedFixedWaitRetryConfigBuilder();
    }

    public Duration getMaxTime() {
        return this.maxTime;
    }

    public Duration getWaitTime() {
        return this.waitTime;
    }

    public void setMaxTime(Duration maxTime) {
        this.maxTime = maxTime;
    }

    public void setWaitTime(Duration waitTime) {
        this.waitTime = waitTime;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimeLimitedFixedWaitRetryConfig)) {
            return false;
        }
        TimeLimitedFixedWaitRetryConfig other = (TimeLimitedFixedWaitRetryConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Duration this$maxTime = this.getMaxTime();
        Duration other$maxTime = other.getMaxTime();
        if (this$maxTime == null ? other$maxTime != null : !this$maxTime.equals(other$maxTime)) {
            return false;
        }
        Duration this$waitTime = this.getWaitTime();
        Duration other$waitTime = other.getWaitTime();
        return !(this$waitTime == null ? other$waitTime != null : !this$waitTime.equals(other$waitTime));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TimeLimitedFixedWaitRetryConfig;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        Duration $maxTime = this.getMaxTime();
        result = result * 59 + ($maxTime == null ? 43 : $maxTime.hashCode());
        Duration $waitTime = this.getWaitTime();
        result = result * 59 + ($waitTime == null ? 43 : $waitTime.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "TimeLimitedFixedWaitRetryConfig(super=" + super.toString() + ", maxTime=" + this.getMaxTime() + ", waitTime=" + this.getWaitTime() + ")";
    }

    public static class TimeLimitedFixedWaitRetryConfigBuilder {
        private Duration maxTime;
        private Duration waitTime;

        TimeLimitedFixedWaitRetryConfigBuilder() {
        }

        public TimeLimitedFixedWaitRetryConfigBuilder maxTime(Duration maxTime) {
            this.maxTime = maxTime;
            return this;
        }

        public TimeLimitedFixedWaitRetryConfigBuilder waitTime(Duration waitTime) {
            this.waitTime = waitTime;
            return this;
        }

        public TimeLimitedFixedWaitRetryConfig build() {
            return new TimeLimitedFixedWaitRetryConfig(this.maxTime, this.waitTime);
        }

        public String toString() {
            return "TimeLimitedFixedWaitRetryConfig.TimeLimitedFixedWaitRetryConfigBuilder(maxTime=" + this.maxTime + ", waitTime=" + this.waitTime + ")";
        }
    }
}

