/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.actors.connectivity;

import com.google.common.collect.ImmutableMap;
import com.rabbitmq.client.Address;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import io.dropwizard.actors.connectivity.config.RMQConfig;
import io.dropwizard.lifecycle.Managed;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RMQConnection
implements Managed {
    private static final Logger log = LoggerFactory.getLogger(RMQConnection.class);
    private final RMQConfig config;
    private Connection connection;
    private Channel channel;
    private static String QUEUE_PREFIX = "promotions.";

    public RMQConnection(RMQConfig config) {
        this.config = config;
    }

    public void start() throws Exception {
        ConnectionFactory factory = new ConnectionFactory();
        factory.setUsername(this.config.getUserName());
        factory.setPassword(this.config.getPassword());
        if (this.config.isSslEnabled()) {
            factory.useSslProtocol();
        }
        factory.setAutomaticRecoveryEnabled(true);
        factory.setTopologyRecoveryEnabled(true);
        factory.setNetworkRecoveryInterval(3000);
        factory.setRequestedHeartbeat(60);
        List<Address> addresses = this.config.getBrokers().stream().map(broker -> new Address(broker.getHost())).collect(Collectors.toList());
        this.connection = factory.newConnection(Executors.newFixedThreadPool(this.config.getThreadPoolSize()), addresses.toArray(new Address[addresses.size()]));
        this.channel = this.connection.createChannel();
    }

    private <T extends Enum<T>> String deriveQueueName(T type, boolean sideline) {
        return QUEUE_PREFIX + (sideline ? this.getSideline(type.name()) : type.name());
    }

    public void ensure(String queueName, String exchange, Map<String, Object> rmqOpts) throws Exception {
        this.ensure(queueName, queueName, exchange, rmqOpts);
    }

    public void ensure(String queueName, String routingQueue, String exchange, Map<String, Object> rmqOpts) throws Exception {
        this.channel.queueDeclare(queueName, true, false, false, rmqOpts);
        this.channel.queueBind(queueName, exchange, routingQueue);
        log.info("Created queue: {}", (Object)queueName);
    }

    public Map<String, Object> rmqOpts() {
        return ImmutableMap.builder().put((Object)"x-ha-policy", (Object)"all").put((Object)"ha-mode", (Object)"all").build();
    }

    public Map<String, Object> rmqOpts(String deadLetterExchange) {
        return ImmutableMap.builder().put((Object)"x-ha-policy", (Object)"all").put((Object)"ha-mode", (Object)"all").put((Object)"x-dead-letter-exchange", (Object)deadLetterExchange).build();
    }

    public void stop() throws Exception {
    }

    public Channel channel() throws IOException {
        return this.channel;
    }

    public Channel newChannel() throws IOException {
        return this.connection.createChannel();
    }

    private String getSideline(String name) {
        return String.format("%s_%s", name, "SIDELINE");
    }

    public RMQConfig getConfig() {
        return this.config;
    }
}

