/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.actors.retry.config;

import io.dropwizard.actors.retry.RetryType;
import io.dropwizard.actors.retry.config.RetryConfig;
import io.dropwizard.util.Duration;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public class CountLimitedExponentialWaitRetryConfig
extends RetryConfig {
    @Min(value=1L)
    private int maxAttempts = 1;
    @NotNull
    @Valid
    private Duration maxTimeBetweenRetries = Duration.milliseconds((long)500L);
    @Min(value=1L)
    @Max(value=0x7FFFFFFFFFFFFFFFL)
    private long multipier = 1L;

    public CountLimitedExponentialWaitRetryConfig() {
        super(RetryType.COUNT_LIMITED_EXPONENTIAL_BACKOFF);
    }

    public CountLimitedExponentialWaitRetryConfig(int maxAttempts, Duration maxTimeBetweenRetries, long multipier) {
        this();
        this.maxAttempts = maxAttempts;
        this.maxTimeBetweenRetries = maxTimeBetweenRetries;
        this.multipier = multipier;
    }

    public static CountLimitedExponentialWaitRetryConfigBuilder builder() {
        return new CountLimitedExponentialWaitRetryConfigBuilder();
    }

    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    public Duration getMaxTimeBetweenRetries() {
        return this.maxTimeBetweenRetries;
    }

    public long getMultipier() {
        return this.multipier;
    }

    public void setMaxAttempts(int maxAttempts) {
        this.maxAttempts = maxAttempts;
    }

    public void setMaxTimeBetweenRetries(Duration maxTimeBetweenRetries) {
        this.maxTimeBetweenRetries = maxTimeBetweenRetries;
    }

    public void setMultipier(long multipier) {
        this.multipier = multipier;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CountLimitedExponentialWaitRetryConfig)) {
            return false;
        }
        CountLimitedExponentialWaitRetryConfig other = (CountLimitedExponentialWaitRetryConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getMaxAttempts() != other.getMaxAttempts()) {
            return false;
        }
        Duration this$maxTimeBetweenRetries = this.getMaxTimeBetweenRetries();
        Duration other$maxTimeBetweenRetries = other.getMaxTimeBetweenRetries();
        if (this$maxTimeBetweenRetries == null ? other$maxTimeBetweenRetries != null : !this$maxTimeBetweenRetries.equals(other$maxTimeBetweenRetries)) {
            return false;
        }
        return this.getMultipier() == other.getMultipier();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CountLimitedExponentialWaitRetryConfig;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        result = result * 59 + this.getMaxAttempts();
        Duration $maxTimeBetweenRetries = this.getMaxTimeBetweenRetries();
        result = result * 59 + ($maxTimeBetweenRetries == null ? 43 : $maxTimeBetweenRetries.hashCode());
        long $multipier = this.getMultipier();
        result = result * 59 + (int)($multipier >>> 32 ^ $multipier);
        return result;
    }

    @Override
    public String toString() {
        return "CountLimitedExponentialWaitRetryConfig(super=" + super.toString() + ", maxAttempts=" + this.getMaxAttempts() + ", maxTimeBetweenRetries=" + this.getMaxTimeBetweenRetries() + ", multipier=" + this.getMultipier() + ")";
    }

    public static class CountLimitedExponentialWaitRetryConfigBuilder {
        private int maxAttempts;
        private Duration maxTimeBetweenRetries;
        private long multipier;

        CountLimitedExponentialWaitRetryConfigBuilder() {
        }

        public CountLimitedExponentialWaitRetryConfigBuilder maxAttempts(int maxAttempts) {
            this.maxAttempts = maxAttempts;
            return this;
        }

        public CountLimitedExponentialWaitRetryConfigBuilder maxTimeBetweenRetries(Duration maxTimeBetweenRetries) {
            this.maxTimeBetweenRetries = maxTimeBetweenRetries;
            return this;
        }

        public CountLimitedExponentialWaitRetryConfigBuilder multipier(long multipier) {
            this.multipier = multipier;
            return this;
        }

        public CountLimitedExponentialWaitRetryConfig build() {
            return new CountLimitedExponentialWaitRetryConfig(this.maxAttempts, this.maxTimeBetweenRetries, this.multipier);
        }

        public String toString() {
            return "CountLimitedExponentialWaitRetryConfig.CountLimitedExponentialWaitRetryConfigBuilder(maxAttempts=" + this.maxAttempts + ", maxTimeBetweenRetries=" + this.maxTimeBetweenRetries + ", multipier=" + this.multipier + ")";
        }
    }
}

