/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.actors.retry.config;

import io.dropwizard.actors.retry.RetryType;
import io.dropwizard.actors.retry.config.RetryConfig;
import io.dropwizard.util.Duration;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public class CountLimitedIncrementalWaitRetryConfig
extends RetryConfig {
    @Min(value=1L)
    private int maxAttempts = 1;
    @NotNull
    @Valid
    private Duration initialWaitTime = Duration.milliseconds((long)500L);
    @NotNull
    @Valid
    private Duration waitIncrement = Duration.milliseconds((long)250L);

    public CountLimitedIncrementalWaitRetryConfig() {
        super(RetryType.COUNT_LIMITED_INCREMENTAL_WAIT);
    }

    public CountLimitedIncrementalWaitRetryConfig(int maxAttempts, Duration initialWaitTime, Duration waitIncrement, Set<String> retriableExceptions) {
        super(RetryType.COUNT_LIMITED_INCREMENTAL_WAIT, retriableExceptions);
        this.maxAttempts = maxAttempts;
        this.initialWaitTime = initialWaitTime;
        this.waitIncrement = waitIncrement;
    }

    public static CountLimitedIncrementalWaitRetryConfigBuilder builder() {
        return new CountLimitedIncrementalWaitRetryConfigBuilder();
    }

    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    public Duration getInitialWaitTime() {
        return this.initialWaitTime;
    }

    public Duration getWaitIncrement() {
        return this.waitIncrement;
    }

    public void setMaxAttempts(int maxAttempts) {
        this.maxAttempts = maxAttempts;
    }

    public void setInitialWaitTime(Duration initialWaitTime) {
        this.initialWaitTime = initialWaitTime;
    }

    public void setWaitIncrement(Duration waitIncrement) {
        this.waitIncrement = waitIncrement;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CountLimitedIncrementalWaitRetryConfig)) {
            return false;
        }
        CountLimitedIncrementalWaitRetryConfig other = (CountLimitedIncrementalWaitRetryConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getMaxAttempts() != other.getMaxAttempts()) {
            return false;
        }
        Duration this$initialWaitTime = this.getInitialWaitTime();
        Duration other$initialWaitTime = other.getInitialWaitTime();
        if (this$initialWaitTime == null ? other$initialWaitTime != null : !this$initialWaitTime.equals(other$initialWaitTime)) {
            return false;
        }
        Duration this$waitIncrement = this.getWaitIncrement();
        Duration other$waitIncrement = other.getWaitIncrement();
        return !(this$waitIncrement == null ? other$waitIncrement != null : !this$waitIncrement.equals(other$waitIncrement));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CountLimitedIncrementalWaitRetryConfig;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        result = result * 59 + this.getMaxAttempts();
        Duration $initialWaitTime = this.getInitialWaitTime();
        result = result * 59 + ($initialWaitTime == null ? 43 : $initialWaitTime.hashCode());
        Duration $waitIncrement = this.getWaitIncrement();
        result = result * 59 + ($waitIncrement == null ? 43 : $waitIncrement.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "CountLimitedIncrementalWaitRetryConfig(super=" + super.toString() + ", maxAttempts=" + this.getMaxAttempts() + ", initialWaitTime=" + this.getInitialWaitTime() + ", waitIncrement=" + this.getWaitIncrement() + ")";
    }

    public static class CountLimitedIncrementalWaitRetryConfigBuilder {
        private int maxAttempts;
        private Duration initialWaitTime;
        private Duration waitIncrement;
        private Set<String> retriableExceptions;

        CountLimitedIncrementalWaitRetryConfigBuilder() {
        }

        public CountLimitedIncrementalWaitRetryConfigBuilder maxAttempts(int maxAttempts) {
            this.maxAttempts = maxAttempts;
            return this;
        }

        public CountLimitedIncrementalWaitRetryConfigBuilder initialWaitTime(Duration initialWaitTime) {
            this.initialWaitTime = initialWaitTime;
            return this;
        }

        public CountLimitedIncrementalWaitRetryConfigBuilder waitIncrement(Duration waitIncrement) {
            this.waitIncrement = waitIncrement;
            return this;
        }

        public CountLimitedIncrementalWaitRetryConfigBuilder retriableExceptions(Set<String> retriableExceptions) {
            this.retriableExceptions = retriableExceptions;
            return this;
        }

        public CountLimitedIncrementalWaitRetryConfig build() {
            return new CountLimitedIncrementalWaitRetryConfig(this.maxAttempts, this.initialWaitTime, this.waitIncrement, this.retriableExceptions);
        }

        public String toString() {
            return "CountLimitedIncrementalWaitRetryConfig.CountLimitedIncrementalWaitRetryConfigBuilder(maxAttempts=" + this.maxAttempts + ", initialWaitTime=" + this.initialWaitTime + ", waitIncrement=" + this.waitIncrement + ", retriableExceptions=" + this.retriableExceptions + ")";
        }
    }
}

