/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.actors;

import com.codahale.metrics.MetricRegistry;
import io.dropwizard.Configuration;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.actors.ExecutorServiceProvider;
import io.dropwizard.actors.config.RMQConfig;
import io.dropwizard.actors.connectivity.RMQConnection;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RabbitmqActorBundle<T extends Configuration>
implements ConfiguredBundle<T> {
    private static final Logger log = LoggerFactory.getLogger(RabbitmqActorBundle.class);
    private RMQConnection connection;
    private ExecutorServiceProvider executorServiceProvider;
    private MetricRegistry metricRegistry;

    protected RabbitmqActorBundle() {
    }

    protected RabbitmqActorBundle(MetricRegistry metricRegistry, ExecutorServiceProvider executorServiceProvider) {
        this.metricRegistry = metricRegistry;
        this.executorServiceProvider = executorServiceProvider;
    }

    public void run(T t, Environment environment) throws Exception {
        RMQConfig config = this.getConfig(t);
        MetricRegistry metrics = this.metrics(environment);
        ExecutorServiceProvider executorServiceProvide = this.executorServiceProvider();
        this.connection = new RMQConnection(config, metrics, executorServiceProvide.newFixedThreadPool("rabbitmq-actors", config.getThreadPoolSize()));
        environment.lifecycle().manage((Managed)this.connection);
        environment.healthChecks().register("rabbitmq-actors", this.connection.healthcheck());
    }

    public void initialize(Bootstrap<?> bootstrap) {
    }

    protected abstract RMQConfig getConfig(T var1);

    protected ExecutorServiceProvider getExecutorServiceProvider(T t) {
        return (name, coreSize) -> Executors.newFixedThreadPool(coreSize);
    }

    private MetricRegistry metrics(Environment environment) {
        if (this.metricRegistry != null) {
            return this.metricRegistry;
        }
        return environment.metrics();
    }

    private ExecutorServiceProvider executorServiceProvider() {
        if (this.executorServiceProvider != null) {
            return this.executorServiceProvider;
        }
        return (name, coreSize) -> Executors.newFixedThreadPool(coreSize);
    }

    public RMQConnection getConnection() {
        return this.connection;
    }
}

