/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.actors.retry.config;

import io.dropwizard.actors.retry.RetryType;
import io.dropwizard.actors.retry.config.RetryConfig;
import io.dropwizard.util.Duration;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

public class TimeLimitedIncrementalWaitRetryConfig
extends RetryConfig {
    @NotNull
    @Valid
    private Duration maxTime = Duration.seconds((long)30L);
    @NotNull
    @Valid
    private Duration initialWaitTime = Duration.milliseconds((long)500L);
    @NotNull
    @Valid
    private Duration waitIncrement = Duration.milliseconds((long)250L);

    public TimeLimitedIncrementalWaitRetryConfig() {
        super(RetryType.TIME_LIMITED_INCREMENTAL_WAIT);
    }

    public TimeLimitedIncrementalWaitRetryConfig(Duration maxTime, Duration initialWaitTime, Duration waitIncrement, Set<String> retriableExceptions) {
        super(RetryType.TIME_LIMITED_INCREMENTAL_WAIT, retriableExceptions);
        this.maxTime = maxTime;
        this.initialWaitTime = initialWaitTime;
        this.waitIncrement = waitIncrement;
    }

    public static TimeLimitedIncrementalWaitRetryConfigBuilder builder() {
        return new TimeLimitedIncrementalWaitRetryConfigBuilder();
    }

    public Duration getMaxTime() {
        return this.maxTime;
    }

    public Duration getInitialWaitTime() {
        return this.initialWaitTime;
    }

    public Duration getWaitIncrement() {
        return this.waitIncrement;
    }

    public void setMaxTime(Duration maxTime) {
        this.maxTime = maxTime;
    }

    public void setInitialWaitTime(Duration initialWaitTime) {
        this.initialWaitTime = initialWaitTime;
    }

    public void setWaitIncrement(Duration waitIncrement) {
        this.waitIncrement = waitIncrement;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimeLimitedIncrementalWaitRetryConfig)) {
            return false;
        }
        TimeLimitedIncrementalWaitRetryConfig other = (TimeLimitedIncrementalWaitRetryConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Duration this$maxTime = this.getMaxTime();
        Duration other$maxTime = other.getMaxTime();
        if (this$maxTime == null ? other$maxTime != null : !this$maxTime.equals(other$maxTime)) {
            return false;
        }
        Duration this$initialWaitTime = this.getInitialWaitTime();
        Duration other$initialWaitTime = other.getInitialWaitTime();
        if (this$initialWaitTime == null ? other$initialWaitTime != null : !this$initialWaitTime.equals(other$initialWaitTime)) {
            return false;
        }
        Duration this$waitIncrement = this.getWaitIncrement();
        Duration other$waitIncrement = other.getWaitIncrement();
        return !(this$waitIncrement == null ? other$waitIncrement != null : !this$waitIncrement.equals(other$waitIncrement));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TimeLimitedIncrementalWaitRetryConfig;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        Duration $maxTime = this.getMaxTime();
        result = result * 59 + ($maxTime == null ? 43 : $maxTime.hashCode());
        Duration $initialWaitTime = this.getInitialWaitTime();
        result = result * 59 + ($initialWaitTime == null ? 43 : $initialWaitTime.hashCode());
        Duration $waitIncrement = this.getWaitIncrement();
        result = result * 59 + ($waitIncrement == null ? 43 : $waitIncrement.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "TimeLimitedIncrementalWaitRetryConfig(super=" + super.toString() + ", maxTime=" + this.getMaxTime() + ", initialWaitTime=" + this.getInitialWaitTime() + ", waitIncrement=" + this.getWaitIncrement() + ")";
    }

    public static class TimeLimitedIncrementalWaitRetryConfigBuilder {
        private Duration maxTime;
        private Duration initialWaitTime;
        private Duration waitIncrement;
        private Set<String> retriableExceptions;

        TimeLimitedIncrementalWaitRetryConfigBuilder() {
        }

        public TimeLimitedIncrementalWaitRetryConfigBuilder maxTime(Duration maxTime) {
            this.maxTime = maxTime;
            return this;
        }

        public TimeLimitedIncrementalWaitRetryConfigBuilder initialWaitTime(Duration initialWaitTime) {
            this.initialWaitTime = initialWaitTime;
            return this;
        }

        public TimeLimitedIncrementalWaitRetryConfigBuilder waitIncrement(Duration waitIncrement) {
            this.waitIncrement = waitIncrement;
            return this;
        }

        public TimeLimitedIncrementalWaitRetryConfigBuilder retriableExceptions(Set<String> retriableExceptions) {
            this.retriableExceptions = retriableExceptions;
            return this;
        }

        public TimeLimitedIncrementalWaitRetryConfig build() {
            return new TimeLimitedIncrementalWaitRetryConfig(this.maxTime, this.initialWaitTime, this.waitIncrement, this.retriableExceptions);
        }

        public String toString() {
            return "TimeLimitedIncrementalWaitRetryConfig.TimeLimitedIncrementalWaitRetryConfigBuilder(maxTime=" + this.maxTime + ", initialWaitTime=" + this.initialWaitTime + ", waitIncrement=" + this.waitIncrement + ", retriableExceptions=" + this.retriableExceptions + ")";
        }
    }
}

