/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.actors.connectivity;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.health.HealthCheck;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.rabbitmq.client.Address;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.MetricsCollector;
import com.rabbitmq.client.impl.StandardMetricsCollector;
import io.dropwizard.actors.config.RMQConfig;
import io.dropwizard.lifecycle.Managed;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.net.ssl.SSLContext;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RMQConnection
implements Managed {
    private static final Logger log = LoggerFactory.getLogger(RMQConnection.class);
    private final RMQConfig config;
    @VisibleForTesting
    private Connection connection;
    private Channel channel;
    private final MetricRegistry metricRegistry;
    private final ExecutorService executorService;

    public RMQConnection(RMQConfig config, MetricRegistry metricRegistry, ExecutorService executorService) {
        this.config = config;
        this.metricRegistry = metricRegistry;
        this.executorService = executorService;
    }

    public void start() throws Exception {
        ConnectionFactory factory = new ConnectionFactory();
        factory.setMetricsCollector((MetricsCollector)new StandardMetricsCollector(this.metricRegistry));
        if (this.config.isSecure()) {
            factory.setUsername(this.config.getUserName());
            factory.setPassword(this.config.getPassword());
            if (Strings.isNullOrEmpty((String)this.config.getCertStorePath())) {
                factory.useSslProtocol();
            } else {
                Preconditions.checkNotNull((Object)this.config.getCertPassword(), (Object)"Cert password is required if cert file path has been provided");
                KeyStore ks = KeyStore.getInstance("JKS");
                ks.load(new FileInputStream(this.config.getCertStorePath()), this.config.getCertPassword().toCharArray());
                KeyStore tks = KeyStore.getInstance("JKS");
                tks.load(new FileInputStream(this.config.getServerCertStorePath()), this.config.getServerCertPassword().toCharArray());
                SSLContext c = SSLContexts.custom().useProtocol("TLSv1.2").loadTrustMaterial(tks, (TrustStrategy)new TrustSelfSignedStrategy()).loadKeyMaterial(ks, this.config.getCertPassword().toCharArray(), (aliases, socket) -> "clientcert").build();
                factory.useSslProtocol(c);
                factory.setVirtualHost(this.config.getUserName());
            }
        } else {
            factory.setUsername(this.config.getUserName());
            factory.setPassword(this.config.getPassword());
        }
        factory.setAutomaticRecoveryEnabled(true);
        factory.setTopologyRecoveryEnabled(true);
        factory.setNetworkRecoveryInterval(3000);
        factory.setRequestedHeartbeat(60);
        this.connection = factory.newConnection(this.executorService, (Address[])this.config.getBrokers().stream().map(broker -> new Address(broker.getHost())).toArray(Address[]::new));
        this.channel = this.connection.createChannel();
    }

    public void ensure(String queueName, String exchange) throws Exception {
        this.ensure(queueName, queueName, exchange, this.rmqOpts());
    }

    public void ensure(String queueName, String exchange, Map<String, Object> rmqOpts) throws Exception {
        this.ensure(queueName, queueName, exchange, rmqOpts);
    }

    public void ensure(String queueName, String routingQueue, String exchange) throws Exception {
        this.ensure(queueName, routingQueue, exchange, this.rmqOpts());
    }

    public void ensure(String queueName, String routingQueue, String exchange, Map<String, Object> rmqOpts) throws Exception {
        this.channel.queueDeclare(queueName, true, false, false, rmqOpts);
        this.channel.queueBind(queueName, exchange, routingQueue);
        log.info("Created queue: {}", (Object)queueName);
    }

    public Map<String, Object> rmqOpts() {
        return ImmutableMap.builder().put((Object)"x-ha-policy", (Object)"all").put((Object)"ha-mode", (Object)"all").build();
    }

    public Map<String, Object> rmqOpts(String deadLetterExchange) {
        return ImmutableMap.builder().put((Object)"x-ha-policy", (Object)"all").put((Object)"ha-mode", (Object)"all").put((Object)"x-dead-letter-exchange", (Object)deadLetterExchange).build();
    }

    public HealthCheck healthcheck() {
        return new HealthCheck(){

            protected HealthCheck.Result check() throws Exception {
                if (RMQConnection.this.connection == null) {
                    log.warn("RMQ Htalthcheck::No RMQ connection available");
                    return HealthCheck.Result.unhealthy((String)"No RMQ connection available");
                }
                if (!RMQConnection.this.connection.isOpen()) {
                    log.warn("RMQ Htalthcheck::RMQ connection is not open");
                    return HealthCheck.Result.unhealthy((String)"RMQ connection is not open");
                }
                if (null == RMQConnection.this.channel) {
                    log.warn("RMQ Htalthcheck::Producer channel is down");
                    return HealthCheck.Result.unhealthy((String)"Producer channel is down");
                }
                if (!RMQConnection.this.channel.isOpen()) {
                    log.warn("RMQ Htalthcheck::Producer channel is closed");
                    return HealthCheck.Result.unhealthy((String)"Producer channel is closed");
                }
                return HealthCheck.Result.healthy();
            }
        };
    }

    public void stop() throws Exception {
        if (null != this.channel && this.channel.isOpen()) {
            this.channel.close();
        }
        if (null != this.connection && this.connection.isOpen()) {
            this.connection.close();
        }
    }

    public Channel channel() throws IOException {
        return this.channel;
    }

    public Channel newChannel() throws IOException {
        return this.connection.createChannel();
    }

    private String getSideline(String name) {
        return String.format("%s_%s", name, "SIDELINE");
    }

    public RMQConfig getConfig() {
        return this.config;
    }

    public Connection getConnection() {
        return this.connection;
    }
}

