/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.auth.jwt;

import io.dropwizard.auth.jwt.JwtAuthorizer;
import io.dropwizard.auth.jwt.annotation.JwtAuthRequired;
import io.dropwizard.auth.jwt.core.JwtUser;
import io.dropwizard.auth.jwt.util.TokenUtils;
import java.lang.reflect.Method;
import java.security.Key;
import java.util.Arrays;
import java.util.stream.Stream;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.FeatureContext;
import javax.ws.rs.core.Response;
import org.jose4j.keys.AesKey;

public class JwtAuthDynamicFeature
implements DynamicFeature {
    private final Key key;
    private final JwtAuthorizer authorizer;

    public JwtAuthDynamicFeature(String key, JwtAuthorizer authorizer) {
        this.key = new AesKey(key.getBytes());
        this.authorizer = authorizer;
    }

    public void configure(ResourceInfo resourceInfo, FeatureContext featureContext) {
        Method resourceMethod = resourceInfo.getResourceMethod();
        if (resourceMethod != null) {
            Stream.of(resourceMethod.getParameterAnnotations()).flatMap(Arrays::stream).filter(annotation -> annotation.annotationType().equals(JwtAuthRequired.class)).map(JwtAuthRequired.class::cast).findFirst().ifPresent(authRequired -> {
                FeatureContext cfr_ignored_0 = (FeatureContext)featureContext.register((Object)this.getAuthFilter());
            });
        }
    }

    private ContainerRequestFilter getAuthFilter() {
        return containerRequestContext -> {
            JwtUser user;
            String authHeader = containerRequestContext.getHeaderString("Authorization");
            if (authHeader == null) {
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            String token = authHeader.startsWith("Bearer:") ? authHeader.replace("Bearer:", "").trim() : authHeader;
            try {
                user = TokenUtils.verify(this.key, token);
                if (this.authorizer != null && !this.authorizer.authorize(user.getClaims(), containerRequestContext)) {
                    throw new WebApplicationException(Response.Status.UNAUTHORIZED);
                }
            }
            catch (Exception e) {
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            containerRequestContext.setProperty("user", (Object)user);
        };
    }

    public static JwtAuthDynamicFeatureBuilder builder() {
        return new JwtAuthDynamicFeatureBuilder();
    }

    public static class JwtAuthDynamicFeatureBuilder {
        private String key;
        private JwtAuthorizer authorizer;

        JwtAuthDynamicFeatureBuilder() {
        }

        public JwtAuthDynamicFeatureBuilder key(String key) {
            this.key = key;
            return this;
        }

        public JwtAuthDynamicFeatureBuilder authorizer(JwtAuthorizer authorizer) {
            this.authorizer = authorizer;
            return this;
        }

        public JwtAuthDynamicFeature build() {
            return new JwtAuthDynamicFeature(this.key, this.authorizer);
        }

        public String toString() {
            return "JwtAuthDynamicFeature.JwtAuthDynamicFeatureBuilder(key=" + this.key + ", authorizer=" + this.authorizer + ")";
        }
    }
}

