/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.auth.jwt;

import io.dropwizard.Configuration;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.auth.jwt.JwtAuthDynamicFeature;
import io.dropwizard.auth.jwt.JwtAuthValueFactoryProvider;
import io.dropwizard.auth.jwt.JwtAuthorizer;
import io.dropwizard.auth.jwt.config.JwtAuthConfig;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;

public abstract class JwtAuthBundle<T extends Configuration>
implements ConfiguredBundle<T> {
    public void run(T configuration, Environment environment) throws Exception {
        JwtAuthConfig jwtAuthConfig = this.getConfig(configuration);
        environment.jersey().register((Object)JwtAuthDynamicFeature.builder().key(jwtAuthConfig.getKey()).authorizer(this.authorizer()).build());
        environment.jersey().register((Object)new JwtAuthValueFactoryProvider.Binder());
    }

    public void initialize(Bootstrap<?> bootstrap) {
    }

    protected abstract JwtAuthConfig getConfig(T var1);

    protected JwtAuthorizer authorizer() {
        return null;
    }
}

