/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.auth.jwt.resources;

import com.codahale.metrics.annotation.Metered;
import io.dropwizard.auth.jwt.config.JwtAuthConfig;
import io.dropwizard.auth.jwt.core.TokenRequest;
import io.dropwizard.auth.jwt.core.TokenResponse;
import io.dropwizard.auth.jwt.util.TokenUtils;
import java.security.Key;
import javax.inject.Singleton;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jose4j.keys.AesKey;
import org.jose4j.lang.JoseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/jwt/v1")
@Singleton
public class TokenResource {
    private static final Logger log = LoggerFactory.getLogger(TokenResource.class);
    private Key key;

    public TokenResource(JwtAuthConfig authConfig) {
        this.key = new AesKey(authConfig.getKey().getBytes());
    }

    @Path(value="/token/generate")
    @POST
    @Metered
    public Response generate(TokenRequest tokenRequest) {
        try {
            String token = TokenUtils.generate(this.key, tokenRequest);
            return Response.ok((Object)TokenResponse.builder().token(token).build()).build();
        }
        catch (JoseException je) {
            throw new WebApplicationException(ExceptionUtils.getRootCauseMessage((Throwable)je), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    public static TokenResourceBuilder builder() {
        return new TokenResourceBuilder();
    }

    public static class TokenResourceBuilder {
        private JwtAuthConfig authConfig;

        TokenResourceBuilder() {
        }

        public TokenResourceBuilder authConfig(JwtAuthConfig authConfig) {
            this.authConfig = authConfig;
            return this;
        }

        public TokenResource build() {
            return new TokenResource(this.authConfig);
        }

        public String toString() {
            return "TokenResource.TokenResourceBuilder(authConfig=" + this.authConfig + ")";
        }
    }
}

