/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.auth.jwt;

import com.google.common.base.Preconditions;
import io.dropwizard.Configuration;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.auth.jwt.JwtAuthDynamicFeature;
import io.dropwizard.auth.jwt.JwtAuthValueFactoryProvider;
import io.dropwizard.auth.jwt.JwtAuthorizer;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import java.security.Key;
import org.jose4j.keys.AesKey;

public abstract class JwtAuthBundle<T extends Configuration>
implements ConfiguredBundle<T> {
    private static Key key;

    public void run(T configuration, Environment environment) throws Exception {
        environment.jersey().register((Object)JwtAuthDynamicFeature.builder().authorizer(this.authorizer()).build());
        environment.jersey().register((Object)new JwtAuthValueFactoryProvider.Binder());
    }

    public void initialize(Bootstrap<?> bootstrap) {
    }

    protected JwtAuthorizer authorizer() {
        return null;
    }

    public static Key getKey() {
        Preconditions.checkNotNull((Object)key, (Object)"JWT Key not set");
        return key;
    }

    public void setKey(byte[] jwtKey) {
        key = new AesKey(jwtKey);
    }
}

