/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.cache.caffeine;

import com.codahale.metrics.MetricRegistry;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.CaffeineSpec;
import io.dropwizard.cache.caffeine.config.CacheConfig;
import io.dropwizard.cache.caffeine.metrics.MetricsStatsCounter;

class CaffeineFactory<K extends Enum<?>> {
    private final MetricRegistry metrics;
    private final String prefix;

    public CaffeineFactory(MetricRegistry metrics, String prefix) {
        this.metrics = metrics;
        this.prefix = prefix;
    }

    public Caffeine fromConfig(CacheConfig config, K key) {
        Caffeine caffeine = Caffeine.from((CaffeineSpec)CaffeineSpec.parse((String)config.getCaffeineSpec()));
        if (config.isMetricsEnabled()) {
            MetricsStatsCounter metricsStatsCounter = new MetricsStatsCounter(this.metrics, this.getCachePrefix(this.prefix, key));
            caffeine.recordStats(() -> metricsStatsCounter);
        }
        return caffeine;
    }

    private String getCachePrefix(String metricsPrefix, K cacheName) {
        return String.format("%s_%s_", metricsPrefix, ((Enum)cacheName).name());
    }
}

