/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.discovery.bundle;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.ranger.ServiceProviderBuilders;
import com.flipkart.ranger.healthcheck.Healthcheck;
import com.flipkart.ranger.healthcheck.HealthcheckStatus;
import com.flipkart.ranger.serviceprovider.ServiceProvider;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import io.dropwizard.Configuration;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.discovery.bundle.InfoResource;
import io.dropwizard.discovery.bundle.ServiceDiscoveryConfiguration;
import io.dropwizard.discovery.client.io.dropwizard.ranger.ServiceDiscoveryClient;
import io.dropwizard.discovery.common.ShardInfo;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import java.net.InetAddress;
import java.util.List;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.RetryForever;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ServiceDiscoveryBundle<T extends Configuration>
implements ConfiguredBundle<T> {
    private static final Logger log = LoggerFactory.getLogger(ServiceDiscoveryBundle.class);
    private ServiceDiscoveryConfiguration serviceDiscoveryConfiguration;
    private List<Healthcheck> healthchecks = Lists.newArrayList();
    private ServiceProvider<ShardInfo> serviceProvider;
    private ServiceDiscoveryClient serviceDiscoveryClient;

    protected ServiceDiscoveryBundle() {
    }

    public void initialize(Bootstrap<?> bootstrap) {
    }

    public void run(T configuration, Environment environment) throws Exception {
        this.serviceDiscoveryConfiguration = this.getRangerConfiguration(configuration);
        ObjectMapper objectMapper = environment.getObjectMapper();
        String namespace = this.serviceDiscoveryConfiguration.getNamespace();
        String serviceName = this.getServiceName(configuration);
        String hostname = this.getHost();
        int port = this.getPort(configuration);
        final CuratorFramework curator = CuratorFrameworkFactory.builder().connectString(this.serviceDiscoveryConfiguration.getZookeeper()).namespace(namespace).retryPolicy((RetryPolicy)new RetryForever(this.serviceDiscoveryConfiguration.getConnectionRetryIntervalMillis())).build();
        this.serviceProvider = ServiceProviderBuilders.shardedServiceProviderBuilder().withCuratorFramework(curator).withNamespace(namespace).withServiceName(serviceName).withSerializer(data -> {
            try {
                return objectMapper.writeValueAsBytes((Object)data);
            }
            catch (Exception e) {
                log.warn("Could not parse node data", (Throwable)e);
                return null;
            }
        }).withHostname(hostname).withPort(port).withNodeData((Object)ShardInfo.builder().environment(this.serviceDiscoveryConfiguration.getEnvironment()).build()).withHealthcheck(() -> {
            for (Healthcheck healthcheck : this.healthchecks) {
                if (HealthcheckStatus.unhealthy != healthcheck.check()) continue;
                return HealthcheckStatus.unhealthy;
            }
            return HealthcheckStatus.healthy;
        }).buildServiceDiscovery();
        this.serviceDiscoveryClient = ServiceDiscoveryClient.fromCurator().curator(curator).namespace(namespace).serviceName(serviceName).environment(this.serviceDiscoveryConfiguration.getEnvironment()).objectMapper(environment.getObjectMapper()).build();
        environment.lifecycle().manage(new Managed(){

            public void start() throws Exception {
                curator.start();
                ServiceDiscoveryBundle.this.serviceProvider.start();
                ServiceDiscoveryBundle.this.serviceDiscoveryClient.start();
            }

            public void stop() throws Exception {
                ServiceDiscoveryBundle.this.serviceDiscoveryClient.stop();
                ServiceDiscoveryBundle.this.serviceProvider.stop();
                curator.close();
            }
        });
        environment.jersey().register((Object)new InfoResource(this.serviceDiscoveryClient));
    }

    protected abstract ServiceDiscoveryConfiguration getRangerConfiguration(T var1);

    protected abstract String getServiceName(T var1);

    protected int getPort(T configuration) {
        Preconditions.checkArgument((-1 != this.serviceDiscoveryConfiguration.getPublishedPort() && 0 != this.serviceDiscoveryConfiguration.getPublishedPort() ? 1 : 0) != 0, (Object)"Looks like publishedPost has not been set and getPort() has not been overridden. This is wrong. \nEither set publishedPort in config or override getPort() to return the port on which the service is running");
        return this.serviceDiscoveryConfiguration.getPublishedPort();
    }

    protected String getHost() throws Exception {
        String host = this.serviceDiscoveryConfiguration.getPublishedHost();
        if (Strings.isNullOrEmpty((String)host) || host.equals("__DEFAULT_SERVICE_HOST")) {
            return InetAddress.getLocalHost().getCanonicalHostName();
        }
        return host;
    }

    public void registerHealthcheck(Healthcheck healthcheck) {
        this.healthchecks.add(healthcheck);
    }

    public void registerHealthchecks(List<Healthcheck> healthchecks) {
        this.healthchecks.addAll(healthchecks);
    }

    public ServiceDiscoveryClient getServiceDiscoveryClient() {
        return this.serviceDiscoveryClient;
    }
}

