/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.discovery.bundle.id;

import com.google.common.collect.ImmutableList;
import io.dropwizard.discovery.bundle.id.CollisionChecker;
import io.dropwizard.discovery.bundle.id.Id;
import io.dropwizard.discovery.bundle.id.constraints.IdValidationConstraint;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class IdGenerator {
    private static SecureRandom random = new SecureRandom(Long.toBinaryString(System.currentTimeMillis()).getBytes());
    private static int nodeId;
    private static DateTimeFormatter formatter;
    private static final CollisionChecker collisionChecker;
    private static List<IdValidationConstraint> globalConstraints;

    public static void initialize(int node) {
        nodeId = node;
    }

    public static void initialize(int node, List<IdValidationConstraint> globalConstraints) {
        nodeId = node;
        IdGenerator.globalConstraints = globalConstraints != null ? globalConstraints : Collections.emptyList();
    }

    public static Id generate(String prefix) {
        IdInfo idInfo = IdGenerator.random();
        DateTime dateTime = new DateTime(idInfo.time);
        String id = String.format("%s%s%04d%03d", prefix, formatter.print((ReadableInstant)dateTime), nodeId, idInfo.exponent);
        return Id.builder().id(id).exponent(idInfo.exponent).generatedDate(dateTime.toDate()).node(nodeId).build();
    }

    public static Id generateWithConstraints(String prefix, IdValidationConstraint ... inConstraints) {
        return IdGenerator.generateWithConstraints(prefix, (List<IdValidationConstraint>)ImmutableList.copyOf((Object[])inConstraints));
    }

    public static Id generateWithConstraints(String prefix, List<IdValidationConstraint> inConstraints) {
        Id id;
        while (!IdGenerator.isValidId(inConstraints, id = IdGenerator.generate(prefix))) {
        }
        return id;
    }

    private static synchronized IdInfo random() {
        int randomGen;
        long time;
        while (!collisionChecker.check(time = System.currentTimeMillis(), randomGen = random.nextInt(1000))) {
        }
        return new IdInfo(randomGen, time);
    }

    private static boolean isValidId(List<IdValidationConstraint> inConstraints, Id id) {
        return globalConstraints.stream().allMatch(constraint -> constraint.isValid(id)) && (null == inConstraints || inConstraints.stream().allMatch(constraint -> constraint.isValid(id)));
    }

    static {
        formatter = DateTimeFormat.forPattern((String)"yyMMddHHmmssSSS");
        collisionChecker = new CollisionChecker();
        globalConstraints = Collections.emptyList();
    }

    private static final class IdInfo {
        int exponent;
        long time;

        public IdInfo(int exponent, long time) {
            this.exponent = exponent;
            this.time = time;
        }
    }
}

