/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.discovery.bundle.id;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.dropwizard.discovery.bundle.id.CollisionChecker;
import io.dropwizard.discovery.bundle.id.Id;
import io.dropwizard.discovery.bundle.id.constraints.IdValidationConstraint;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class IdGenerator {
    private static SecureRandom random = new SecureRandom(Long.toBinaryString(System.currentTimeMillis()).getBytes());
    private static int nodeId;
    private static DateTimeFormatter formatter;
    private static final CollisionChecker collisionChecker;
    private static List<IdValidationConstraint> globalConstraints;
    private static Map<String, List<IdValidationConstraint>> domainSpecificConstraints;

    public static void initialize(int node) {
        nodeId = node;
    }

    public static void initialize(int node, List<IdValidationConstraint> globalConstraints, Map<String, List<IdValidationConstraint>> domainSpecificConstraints) {
        nodeId = node;
        IdGenerator.globalConstraints = globalConstraints != null ? globalConstraints : Collections.emptyList();
        IdGenerator.domainSpecificConstraints.putAll(domainSpecificConstraints);
    }

    public void registerDomainSpecificConstraints(String domain, IdValidationConstraint ... validationConstraints) {
        Preconditions.checkArgument((null != validationConstraints && validationConstraints.length == 0 ? 1 : 0) != 0);
        if (domainSpecificConstraints.containsKey(domain)) {
            domainSpecificConstraints.get(domain).addAll((Collection<IdValidationConstraint>)ImmutableList.copyOf((Object[])validationConstraints));
        } else {
            domainSpecificConstraints.put(domain, new ArrayList(ImmutableList.copyOf((Object[])validationConstraints)));
        }
    }

    public static Id generate(String prefix) {
        IdInfo idInfo = IdGenerator.random();
        DateTime dateTime = new DateTime(idInfo.time);
        String id = String.format("%s%s%04d%03d", prefix, formatter.print((ReadableInstant)dateTime), nodeId, idInfo.exponent);
        return Id.builder().id(id).exponent(idInfo.exponent).generatedDate(dateTime.toDate()).node(nodeId).build();
    }

    public static Id generateWithConstraints(String prefix, String domain) {
        return IdGenerator.generateWithConstraints(prefix, domainSpecificConstraints.getOrDefault(domain, Collections.emptyList()), true);
    }

    public static Id generateWithConstraints(String prefix, String domain, boolean skipGlobal) {
        return IdGenerator.generateWithConstraints(prefix, domainSpecificConstraints.getOrDefault(domain, Collections.emptyList()), skipGlobal);
    }

    public static Id generateWithConstraints(String prefix, List<IdValidationConstraint> inConstraints) {
        return IdGenerator.generateWithConstraints(prefix, inConstraints, false);
    }

    public static Id generateWithConstraints(String prefix, List<IdValidationConstraint> inConstraints, boolean skipGlobal) {
        Id id;
        while (!IdGenerator.isValidId(inConstraints, id = IdGenerator.generate(prefix), skipGlobal)) {
        }
        return id;
    }

    private static synchronized IdInfo random() {
        int randomGen;
        long time;
        while (!collisionChecker.check(time = System.currentTimeMillis(), randomGen = random.nextInt(1000))) {
        }
        return new IdInfo(randomGen, time);
    }

    private static boolean isValidId(List<IdValidationConstraint> inConstraints, Id id, boolean skipGlobal) {
        return !(!skipGlobal && !globalConstraints.stream().allMatch(constraint -> constraint.isValid(id)) || null != inConstraints && !inConstraints.stream().allMatch(constraint -> constraint.isValid(id)));
    }

    static {
        formatter = DateTimeFormat.forPattern((String)"yyMMddHHmmssSSS");
        collisionChecker = new CollisionChecker();
        globalConstraints = Collections.emptyList();
        domainSpecificConstraints = new HashMap<String, List<IdValidationConstraint>>();
    }

    private static final class IdInfo {
        int exponent;
        long time;

        public IdInfo(int exponent, long time) {
            this.exponent = exponent;
            this.time = time;
        }
    }
}

