/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.discovery.bundle;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.NotEmpty;

public class ServiceDiscoveryConfiguration {
    @NotNull
    @NotEmpty
    private String namespace = "default";
    @NotNull
    @NotEmpty
    private String environment;
    @NotNull
    @NotEmpty
    private String zookeeper;
    @Min(value=1000L)
    @Max(value=60000L)
    private int connectionRetryIntervalMillis = 5000;
    @NotNull
    @NotEmpty
    private String publishedHost = "__DEFAULT_SERVICE_HOST";
    @NotNull
    @Min(value=-1L)
    @Max(value=65535L)
    private int publishedPort = -1;
    private int refreshTimeMs;
    private boolean disableWatchers;
    @Min(value=0L)
    @Max(value=600L)
    private long initialDelaySeconds;
    private boolean initialRotationStatus = true;

    private ServiceDiscoveryConfiguration(String namespace, String environment, String zookeeper, int connectionRetryIntervalMillis, String publishedHost, int publishedPort, boolean initialRotationStatus, int refreshTimeMs, boolean disableWatchers, long initialDelaySeconds) {
        this.namespace = namespace;
        this.environment = environment;
        this.zookeeper = zookeeper;
        this.connectionRetryIntervalMillis = connectionRetryIntervalMillis;
        this.publishedHost = publishedHost;
        this.publishedPort = publishedPort;
        this.initialRotationStatus = initialRotationStatus;
        this.refreshTimeMs = refreshTimeMs;
        this.disableWatchers = disableWatchers;
        this.initialDelaySeconds = initialDelaySeconds;
    }

    public static ServiceDiscoveryConfigurationBuilder builder() {
        return new ServiceDiscoveryConfigurationBuilder();
    }

    public ServiceDiscoveryConfiguration() {
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public String getZookeeper() {
        return this.zookeeper;
    }

    public int getConnectionRetryIntervalMillis() {
        return this.connectionRetryIntervalMillis;
    }

    public String getPublishedHost() {
        return this.publishedHost;
    }

    public int getPublishedPort() {
        return this.publishedPort;
    }

    public int getRefreshTimeMs() {
        return this.refreshTimeMs;
    }

    public boolean isDisableWatchers() {
        return this.disableWatchers;
    }

    public long getInitialDelaySeconds() {
        return this.initialDelaySeconds;
    }

    public boolean isInitialRotationStatus() {
        return this.initialRotationStatus;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public void setZookeeper(String zookeeper) {
        this.zookeeper = zookeeper;
    }

    public void setConnectionRetryIntervalMillis(int connectionRetryIntervalMillis) {
        this.connectionRetryIntervalMillis = connectionRetryIntervalMillis;
    }

    public void setPublishedHost(String publishedHost) {
        this.publishedHost = publishedHost;
    }

    public void setPublishedPort(int publishedPort) {
        this.publishedPort = publishedPort;
    }

    public void setRefreshTimeMs(int refreshTimeMs) {
        this.refreshTimeMs = refreshTimeMs;
    }

    public void setDisableWatchers(boolean disableWatchers) {
        this.disableWatchers = disableWatchers;
    }

    public void setInitialDelaySeconds(long initialDelaySeconds) {
        this.initialDelaySeconds = initialDelaySeconds;
    }

    public void setInitialRotationStatus(boolean initialRotationStatus) {
        this.initialRotationStatus = initialRotationStatus;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServiceDiscoveryConfiguration)) {
            return false;
        }
        ServiceDiscoveryConfiguration other = (ServiceDiscoveryConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        String this$environment = this.getEnvironment();
        String other$environment = other.getEnvironment();
        if (this$environment == null ? other$environment != null : !this$environment.equals(other$environment)) {
            return false;
        }
        String this$zookeeper = this.getZookeeper();
        String other$zookeeper = other.getZookeeper();
        if (this$zookeeper == null ? other$zookeeper != null : !this$zookeeper.equals(other$zookeeper)) {
            return false;
        }
        if (this.getConnectionRetryIntervalMillis() != other.getConnectionRetryIntervalMillis()) {
            return false;
        }
        String this$publishedHost = this.getPublishedHost();
        String other$publishedHost = other.getPublishedHost();
        if (this$publishedHost == null ? other$publishedHost != null : !this$publishedHost.equals(other$publishedHost)) {
            return false;
        }
        if (this.getPublishedPort() != other.getPublishedPort()) {
            return false;
        }
        if (this.getRefreshTimeMs() != other.getRefreshTimeMs()) {
            return false;
        }
        if (this.isDisableWatchers() != other.isDisableWatchers()) {
            return false;
        }
        if (this.getInitialDelaySeconds() != other.getInitialDelaySeconds()) {
            return false;
        }
        return this.isInitialRotationStatus() == other.isInitialRotationStatus();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServiceDiscoveryConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        String $environment = this.getEnvironment();
        result = result * 59 + ($environment == null ? 43 : $environment.hashCode());
        String $zookeeper = this.getZookeeper();
        result = result * 59 + ($zookeeper == null ? 43 : $zookeeper.hashCode());
        result = result * 59 + this.getConnectionRetryIntervalMillis();
        String $publishedHost = this.getPublishedHost();
        result = result * 59 + ($publishedHost == null ? 43 : $publishedHost.hashCode());
        result = result * 59 + this.getPublishedPort();
        result = result * 59 + this.getRefreshTimeMs();
        result = result * 59 + (this.isDisableWatchers() ? 79 : 97);
        long $initialDelaySeconds = this.getInitialDelaySeconds();
        result = result * 59 + (int)($initialDelaySeconds >>> 32 ^ $initialDelaySeconds);
        result = result * 59 + (this.isInitialRotationStatus() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "ServiceDiscoveryConfiguration(namespace=" + this.getNamespace() + ", environment=" + this.getEnvironment() + ", zookeeper=" + this.getZookeeper() + ", connectionRetryIntervalMillis=" + this.getConnectionRetryIntervalMillis() + ", publishedHost=" + this.getPublishedHost() + ", publishedPort=" + this.getPublishedPort() + ", refreshTimeMs=" + this.getRefreshTimeMs() + ", disableWatchers=" + this.isDisableWatchers() + ", initialDelaySeconds=" + this.getInitialDelaySeconds() + ", initialRotationStatus=" + this.isInitialRotationStatus() + ")";
    }

    public static class ServiceDiscoveryConfigurationBuilder {
        private String namespace;
        private String environment;
        private String zookeeper;
        private int connectionRetryIntervalMillis;
        private String publishedHost;
        private int publishedPort;
        private boolean initialRotationStatus;
        private int refreshTimeMs;
        private boolean disableWatchers;
        private long initialDelaySeconds;

        ServiceDiscoveryConfigurationBuilder() {
        }

        public ServiceDiscoveryConfigurationBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public ServiceDiscoveryConfigurationBuilder environment(String environment) {
            this.environment = environment;
            return this;
        }

        public ServiceDiscoveryConfigurationBuilder zookeeper(String zookeeper) {
            this.zookeeper = zookeeper;
            return this;
        }

        public ServiceDiscoveryConfigurationBuilder connectionRetryIntervalMillis(int connectionRetryIntervalMillis) {
            this.connectionRetryIntervalMillis = connectionRetryIntervalMillis;
            return this;
        }

        public ServiceDiscoveryConfigurationBuilder publishedHost(String publishedHost) {
            this.publishedHost = publishedHost;
            return this;
        }

        public ServiceDiscoveryConfigurationBuilder publishedPort(int publishedPort) {
            this.publishedPort = publishedPort;
            return this;
        }

        public ServiceDiscoveryConfigurationBuilder initialRotationStatus(boolean initialRotationStatus) {
            this.initialRotationStatus = initialRotationStatus;
            return this;
        }

        public ServiceDiscoveryConfigurationBuilder refreshTimeMs(int refreshTimeMs) {
            this.refreshTimeMs = refreshTimeMs;
            return this;
        }

        public ServiceDiscoveryConfigurationBuilder disableWatchers(boolean disableWatchers) {
            this.disableWatchers = disableWatchers;
            return this;
        }

        public ServiceDiscoveryConfigurationBuilder initialDelaySeconds(long initialDelaySeconds) {
            this.initialDelaySeconds = initialDelaySeconds;
            return this;
        }

        public ServiceDiscoveryConfiguration build() {
            return new ServiceDiscoveryConfiguration(this.namespace, this.environment, this.zookeeper, this.connectionRetryIntervalMillis, this.publishedHost, this.publishedPort, this.initialRotationStatus, this.refreshTimeMs, this.disableWatchers, this.initialDelaySeconds);
        }

        public String toString() {
            return "ServiceDiscoveryConfiguration.ServiceDiscoveryConfigurationBuilder(namespace=" + this.namespace + ", environment=" + this.environment + ", zookeeper=" + this.zookeeper + ", connectionRetryIntervalMillis=" + this.connectionRetryIntervalMillis + ", publishedHost=" + this.publishedHost + ", publishedPort=" + this.publishedPort + ", initialRotationStatus=" + this.initialRotationStatus + ", refreshTimeMs=" + this.refreshTimeMs + ", disableWatchers=" + this.disableWatchers + ", initialDelaySeconds=" + this.initialDelaySeconds + ")";
        }
    }
}

