/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.discovery.bundle.id;

import io.dropwizard.discovery.bundle.id.CollisionChecker;
import io.dropwizard.discovery.bundle.id.Id;
import java.security.SecureRandom;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class IdGenerator {
    private static SecureRandom random = new SecureRandom(Long.toBinaryString(System.currentTimeMillis()).getBytes());
    private static int nodeId;
    private static DateTimeFormatter formatter;
    private static final CollisionChecker collisionChecker;

    public static void initialize(int node) {
        nodeId = node;
    }

    public static Id generate(String prefix) {
        IdInfo idInfo = IdGenerator.random();
        DateTime dateTime = new DateTime(idInfo.time);
        String id = String.format("%s%s%04d%03d", prefix, formatter.print((ReadableInstant)dateTime), nodeId, idInfo.exponent);
        return Id.builder().id(id).exponent(idInfo.exponent).generatedDate(dateTime.toDate()).node(nodeId).build();
    }

    private static synchronized IdInfo random() {
        int randomGen;
        long time;
        while (!collisionChecker.check(time = System.currentTimeMillis(), randomGen = random.nextInt(1000))) {
        }
        return new IdInfo(randomGen, time);
    }

    static {
        formatter = DateTimeFormat.forPattern((String)"yyMMddHHmmssSSS");
        collisionChecker = new CollisionChecker();
    }

    private static final class IdInfo {
        int exponent;
        long time;

        public IdInfo(int exponent, long time) {
            this.exponent = exponent;
            this.time = time;
        }
    }
}

