/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.discovery.bundle.id;

import com.github.rholder.retry.RetryException;
import com.github.rholder.retry.Retryer;
import com.github.rholder.retry.RetryerBuilder;
import com.github.rholder.retry.StopStrategies;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.dropwizard.discovery.bundle.id.CollisionChecker;
import io.dropwizard.discovery.bundle.id.Id;
import io.dropwizard.discovery.bundle.id.constraints.IdValidationConstraint;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdGenerator {
    private static final Logger log = LoggerFactory.getLogger(IdGenerator.class);
    private static SecureRandom random = new SecureRandom(Long.toBinaryString(System.currentTimeMillis()).getBytes());
    private static int nodeId;
    private static DateTimeFormatter formatter;
    private static final CollisionChecker collisionChecker;
    private static List<IdValidationConstraint> globalConstraints;
    private static Map<String, List<IdValidationConstraint>> domainSpecificConstraints;
    private static final Retryer<GenerationResult> retrier;

    public static void initialize(int node) {
        nodeId = node;
    }

    public static void initialize(int node, List<IdValidationConstraint> globalConstraints, Map<String, List<IdValidationConstraint>> domainSpecificConstraints) {
        nodeId = node;
        IdGenerator.globalConstraints = globalConstraints != null ? globalConstraints : Collections.emptyList();
        IdGenerator.domainSpecificConstraints.putAll(domainSpecificConstraints);
    }

    public static synchronized void registerGlobalConstraints(IdValidationConstraint ... constraints) {
        IdGenerator.registerGlobalConstraints((List<IdValidationConstraint>)ImmutableList.copyOf((Object[])constraints));
    }

    public static synchronized void registerGlobalConstraints(List<IdValidationConstraint> constraints) {
        Preconditions.checkArgument((null != constraints && !constraints.isEmpty() ? 1 : 0) != 0);
        if (null == globalConstraints) {
            globalConstraints = new ArrayList<IdValidationConstraint>();
        }
        globalConstraints.addAll(constraints);
    }

    public static synchronized void registerDomainSpecificConstraints(String domain, IdValidationConstraint ... validationConstraints) {
        IdGenerator.registerDomainSpecificConstraints(domain, (List<IdValidationConstraint>)ImmutableList.copyOf((Object[])validationConstraints));
    }

    public static synchronized void registerDomainSpecificConstraints(String domain, List<IdValidationConstraint> validationConstraints) {
        Preconditions.checkArgument((null != validationConstraints && !validationConstraints.isEmpty() ? 1 : 0) != 0);
        if (!domainSpecificConstraints.containsKey(domain)) {
            domainSpecificConstraints.put(domain, new ArrayList());
        }
        domainSpecificConstraints.get(domain).addAll(validationConstraints);
    }

    public static Id generate(String prefix) {
        IdInfo idInfo = IdGenerator.random();
        DateTime dateTime = new DateTime(idInfo.time);
        String id = String.format("%s%s%04d%03d", prefix, formatter.print((ReadableInstant)dateTime), nodeId, idInfo.exponent);
        return Id.builder().id(id).exponent(idInfo.exponent).generatedDate(dateTime.toDate()).node(nodeId).build();
    }

    public static Optional<Id> generateWithConstraints(String prefix, String domain) {
        return IdGenerator.generateWithConstraints(prefix, domainSpecificConstraints.getOrDefault(domain, Collections.emptyList()), true);
    }

    public static Optional<Id> generateWithConstraints(String prefix, String domain, boolean skipGlobal) {
        return IdGenerator.generateWithConstraints(prefix, domainSpecificConstraints.getOrDefault(domain, Collections.emptyList()), skipGlobal);
    }

    public static Optional<Id> generateWithConstraints(String prefix, List<IdValidationConstraint> inConstraints) {
        return IdGenerator.generateWithConstraints(prefix, inConstraints, false);
    }

    public static Optional<Id> generateWithConstraints(String prefix, List<IdValidationConstraint> inConstraints, boolean skipGlobal) {
        try {
            GenerationResult generationResult = (GenerationResult)retrier.call(() -> {
                Id id = IdGenerator.generate(prefix);
                return new GenerationResult(id, IdGenerator.validateId(inConstraints, id, skipGlobal));
            });
            return Optional.ofNullable(generationResult.getId());
        }
        catch (ExecutionException e) {
            log.error("Error occurred while generating id with prefix " + prefix, (Throwable)e);
        }
        catch (RetryException e) {
            log.error("Failed to generate id with prefix " + prefix + " after max attempts (512)", (Throwable)e);
        }
        return Optional.empty();
    }

    private static synchronized IdInfo random() {
        int randomGen;
        long time;
        while (!collisionChecker.check(time = System.currentTimeMillis(), randomGen = random.nextInt(1000))) {
        }
        return new IdInfo(randomGen, time);
    }

    private static IdValidationState validateId(List<IdValidationConstraint> inConstraints, Id id, boolean skipGlobal) {
        IdValidationConstraint failedLocalConstraint;
        IdValidationConstraint failedGlobalConstraint;
        IdValidationConstraint idValidationConstraint = failedGlobalConstraint = skipGlobal || null == globalConstraints ? null : (IdValidationConstraint)globalConstraints.stream().filter(constraint -> !constraint.isValid(id)).findFirst().orElse(null);
        if (null != failedGlobalConstraint) {
            return failedGlobalConstraint.failFast() ? IdValidationState.INVALID_NON_RETRYABLE : IdValidationState.INVALID_RETRYABLE;
        }
        IdValidationConstraint idValidationConstraint2 = failedLocalConstraint = null == inConstraints ? null : (IdValidationConstraint)inConstraints.stream().filter(constraint -> !constraint.isValid(id)).findFirst().orElse(null);
        if (null != failedLocalConstraint) {
            return failedLocalConstraint.failFast() ? IdValidationState.INVALID_NON_RETRYABLE : IdValidationState.INVALID_RETRYABLE;
        }
        return IdValidationState.VALID;
    }

    static {
        formatter = DateTimeFormat.forPattern((String)"yyMMddHHmmssSSS");
        collisionChecker = new CollisionChecker();
        globalConstraints = Collections.emptyList();
        domainSpecificConstraints = new HashMap<String, List<IdValidationConstraint>>();
        retrier = RetryerBuilder.newBuilder().withStopStrategy(StopStrategies.stopAfterAttempt((int)512)).retryIfException().retryIfResult(Objects::isNull).retryIfResult(result -> result.getState().equals((Object)IdValidationState.INVALID_RETRYABLE)).build();
    }

    private static class GenerationResult {
        private final Id id;
        private final IdValidationState state;

        public GenerationResult(Id id, IdValidationState state) {
            this.id = id;
            this.state = state;
        }

        public Id getId() {
            return this.id;
        }

        public IdValidationState getState() {
            return this.state;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GenerationResult)) {
                return false;
            }
            GenerationResult other = (GenerationResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Id this$id = this.getId();
            Id other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            IdValidationState this$state = this.getState();
            IdValidationState other$state = other.getState();
            return !(this$state == null ? other$state != null : !((Object)((Object)this$state)).equals((Object)other$state));
        }

        protected boolean canEqual(Object other) {
            return other instanceof GenerationResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Id $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            IdValidationState $state = this.getState();
            result = result * 59 + ($state == null ? 43 : ((Object)((Object)$state)).hashCode());
            return result;
        }

        public String toString() {
            return "IdGenerator.GenerationResult(id=" + this.getId() + ", state=" + (Object)((Object)this.getState()) + ")";
        }
    }

    private static final class IdInfo {
        int exponent;
        long time;

        public IdInfo(int exponent, long time) {
            this.exponent = exponent;
            this.time = time;
        }
    }

    private static enum IdValidationState {
        VALID,
        INVALID_RETRYABLE,
        INVALID_NON_RETRYABLE;

    }
}

