/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.maxmind.geoip2.config;

import java.beans.ConstructorProperties;
import org.hibernate.validator.constraints.NotEmpty;

public class MaxMindConfig {
    @NotEmpty
    private String databaseFilePath;
    private String remoteIpHeader = "X-FORWARDED-FOR";
    private int cacheTTL = 300;
    private int cacheMaxEntries = 10000;
    private boolean enterprise = false;
    private String type;
    private boolean maxMindContext = false;

    public static MaxMindConfigBuilder builder() {
        return new MaxMindConfigBuilder();
    }

    public String getDatabaseFilePath() {
        return this.databaseFilePath;
    }

    public String getRemoteIpHeader() {
        return this.remoteIpHeader;
    }

    public int getCacheTTL() {
        return this.cacheTTL;
    }

    public int getCacheMaxEntries() {
        return this.cacheMaxEntries;
    }

    public boolean isEnterprise() {
        return this.enterprise;
    }

    public String getType() {
        return this.type;
    }

    public boolean isMaxMindContext() {
        return this.maxMindContext;
    }

    public void setDatabaseFilePath(String databaseFilePath) {
        this.databaseFilePath = databaseFilePath;
    }

    public void setRemoteIpHeader(String remoteIpHeader) {
        this.remoteIpHeader = remoteIpHeader;
    }

    public void setCacheTTL(int cacheTTL) {
        this.cacheTTL = cacheTTL;
    }

    public void setCacheMaxEntries(int cacheMaxEntries) {
        this.cacheMaxEntries = cacheMaxEntries;
    }

    public void setEnterprise(boolean enterprise) {
        this.enterprise = enterprise;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setMaxMindContext(boolean maxMindContext) {
        this.maxMindContext = maxMindContext;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MaxMindConfig)) {
            return false;
        }
        MaxMindConfig other = (MaxMindConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$databaseFilePath = this.getDatabaseFilePath();
        String other$databaseFilePath = other.getDatabaseFilePath();
        if (this$databaseFilePath == null ? other$databaseFilePath != null : !this$databaseFilePath.equals(other$databaseFilePath)) {
            return false;
        }
        String this$remoteIpHeader = this.getRemoteIpHeader();
        String other$remoteIpHeader = other.getRemoteIpHeader();
        if (this$remoteIpHeader == null ? other$remoteIpHeader != null : !this$remoteIpHeader.equals(other$remoteIpHeader)) {
            return false;
        }
        if (this.getCacheTTL() != other.getCacheTTL()) {
            return false;
        }
        if (this.getCacheMaxEntries() != other.getCacheMaxEntries()) {
            return false;
        }
        if (this.isEnterprise() != other.isEnterprise()) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        return this.isMaxMindContext() == other.isMaxMindContext();
    }

    protected boolean canEqual(Object other) {
        return other instanceof MaxMindConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $databaseFilePath = this.getDatabaseFilePath();
        result = result * 59 + ($databaseFilePath == null ? 43 : $databaseFilePath.hashCode());
        String $remoteIpHeader = this.getRemoteIpHeader();
        result = result * 59 + ($remoteIpHeader == null ? 43 : $remoteIpHeader.hashCode());
        result = result * 59 + this.getCacheTTL();
        result = result * 59 + this.getCacheMaxEntries();
        result = result * 59 + (this.isEnterprise() ? 79 : 97);
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        result = result * 59 + (this.isMaxMindContext() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "MaxMindConfig(databaseFilePath=" + this.getDatabaseFilePath() + ", remoteIpHeader=" + this.getRemoteIpHeader() + ", cacheTTL=" + this.getCacheTTL() + ", cacheMaxEntries=" + this.getCacheMaxEntries() + ", enterprise=" + this.isEnterprise() + ", type=" + this.getType() + ", maxMindContext=" + this.isMaxMindContext() + ")";
    }

    @ConstructorProperties(value={"databaseFilePath", "remoteIpHeader", "cacheTTL", "cacheMaxEntries", "enterprise", "type", "maxMindContext"})
    public MaxMindConfig(String databaseFilePath, String remoteIpHeader, int cacheTTL, int cacheMaxEntries, boolean enterprise, String type, boolean maxMindContext) {
        this.databaseFilePath = databaseFilePath;
        this.remoteIpHeader = remoteIpHeader;
        this.cacheTTL = cacheTTL;
        this.cacheMaxEntries = cacheMaxEntries;
        this.enterprise = enterprise;
        this.type = type;
        this.maxMindContext = maxMindContext;
    }

    public MaxMindConfig() {
    }

    public static class MaxMindConfigBuilder {
        private String databaseFilePath;
        private String remoteIpHeader;
        private int cacheTTL;
        private int cacheMaxEntries;
        private boolean enterprise;
        private String type;
        private boolean maxMindContext;

        MaxMindConfigBuilder() {
        }

        public MaxMindConfigBuilder databaseFilePath(String databaseFilePath) {
            this.databaseFilePath = databaseFilePath;
            return this;
        }

        public MaxMindConfigBuilder remoteIpHeader(String remoteIpHeader) {
            this.remoteIpHeader = remoteIpHeader;
            return this;
        }

        public MaxMindConfigBuilder cacheTTL(int cacheTTL) {
            this.cacheTTL = cacheTTL;
            return this;
        }

        public MaxMindConfigBuilder cacheMaxEntries(int cacheMaxEntries) {
            this.cacheMaxEntries = cacheMaxEntries;
            return this;
        }

        public MaxMindConfigBuilder enterprise(boolean enterprise) {
            this.enterprise = enterprise;
            return this;
        }

        public MaxMindConfigBuilder type(String type) {
            this.type = type;
            return this;
        }

        public MaxMindConfigBuilder maxMindContext(boolean maxMindContext) {
            this.maxMindContext = maxMindContext;
            return this;
        }

        public MaxMindConfig build() {
            return new MaxMindConfig(this.databaseFilePath, this.remoteIpHeader, this.cacheTTL, this.cacheMaxEntries, this.enterprise, this.type, this.maxMindContext);
        }

        public String toString() {
            return "MaxMindConfig.MaxMindConfigBuilder(databaseFilePath=" + this.databaseFilePath + ", remoteIpHeader=" + this.remoteIpHeader + ", cacheTTL=" + this.cacheTTL + ", cacheMaxEntries=" + this.cacheMaxEntries + ", enterprise=" + this.enterprise + ", type=" + this.type + ", maxMindContext=" + this.maxMindContext + ")";
        }
    }
}

