/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.msgpack;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.dropwizard.msgpack.MsgPackMediaType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.msgpack.jackson.dataformat.MessagePackFactory;

@Provider
@Consumes(value={"application/msgpack"})
@Produces(value={"application/msgpack"})
public class MsgPackMessageBodyProvider<T>
implements MessageBodyReader<T>,
MessageBodyWriter<T> {
    public static final ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new MessagePackFactory());

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return mediaType.isCompatible(MsgPackMediaType.APPLICATION_MSGPACK_TYPE);
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return mediaType.isCompatible(MsgPackMediaType.APPLICATION_MSGPACK_TYPE);
    }

    public T readFrom(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        return (T)objectMapper.readValue(entityStream, type);
    }

    public void writeTo(Object o, Class aClass, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap multivaluedMap, OutputStream outputStream) throws IOException, WebApplicationException {
        outputStream.write(objectMapper.writeValueAsBytes(o));
    }

    public long getSize(Object o, Class aClass, Type type, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }
}

