/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.primer.cache;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.CacheStats;
import com.google.common.cache.LoadingCache;
import io.dropwizard.primer.model.PrimerBundleConfiguration;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenCacheManager {
    private static final Logger log = LoggerFactory.getLogger(TokenCacheManager.class);
    private static LoadingCache<String, Optional<Boolean>> blacklistCache;
    private static LoadingCache<String, Optional<Boolean>> lruCache;

    public static void init(PrimerBundleConfiguration configuration) {
        blacklistCache = CacheBuilder.newBuilder().maximumSize((long)configuration.getCacheMaxSize()).expireAfterWrite((long)configuration.getCacheExpiry(), TimeUnit.SECONDS).removalListener(notification -> log.info("Blacklisted Token Evicted: " + (String)notification.getKey())).recordStats().build((CacheLoader)new CacheLoader<String, Optional<Boolean>>(){

            public Optional<Boolean> load(String key) throws Exception {
                return Optional.of(false);
            }
        });
        lruCache = CacheBuilder.newBuilder().expireAfterWrite((long)configuration.getCacheExpiry(), TimeUnit.SECONDS).removalListener(notification -> log.info("Token Evicted: " + (String)notification.getKey())).maximumSize((long)configuration.getCacheMaxSize()).recordStats().build((CacheLoader)new CacheLoader<String, Optional<Boolean>>(){

            public Optional<Boolean> load(String key) throws Exception {
                return Optional.of(false);
            }
        });
    }

    public static void blackList(String token) {
        blacklistCache.put((Object)token, Optional.of(true));
    }

    public static void cache(String token) {
        lruCache.put((Object)token, Optional.of(true));
    }

    public static boolean checkCache(String token) {
        try {
            Optional result = (Optional)lruCache.get((Object)token);
            if (result.isPresent()) {
                return (Boolean)result.get();
            }
            return false;
        }
        catch (ExecutionException e) {
            return false;
        }
    }

    public static boolean checkBlackList(String token) throws ExecutionException {
        return (Boolean)((Optional)blacklistCache.get((Object)token)).get();
    }

    public static CacheStats cacheStats() {
        return lruCache.stats();
    }
}

