/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.primer;

import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.github.toastshaman.dropwizard.auth.jwt.JsonWebTokenParser;
import com.github.toastshaman.dropwizard.auth.jwt.hmac.HmacSHA512Verifier;
import com.github.toastshaman.dropwizard.auth.jwt.parser.DefaultJsonWebTokenParser;
import feign.Client;
import feign.Feign;
import feign.Logger;
import feign.Target;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import feign.okhttp.OkHttpClient;
import feign.ranger.RangerTarget;
import feign.slf4j.Slf4jLogger;
import io.dropwizard.Configuration;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.primer.auth.PrimerAuthenticatorRequestFilter;
import io.dropwizard.primer.auth.PrimerAuthorizationRegistry;
import io.dropwizard.primer.cache.TokenCacheManager;
import io.dropwizard.primer.client.PrimerClient;
import io.dropwizard.primer.core.PrimerError;
import io.dropwizard.primer.exception.PrimerException;
import io.dropwizard.primer.exception.PrimerExceptionMapper;
import io.dropwizard.primer.model.PrimerAuthorizationMatrix;
import io.dropwizard.primer.model.PrimerBundleConfiguration;
import io.dropwizard.primer.model.PrimerRangerEndpoint;
import io.dropwizard.primer.model.PrimerSimpleEndpoint;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.RetryNTimes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PrimerBundle<T extends Configuration>
implements ConfiguredBundle<T> {
    private static final Logger log = LoggerFactory.getLogger(PrimerBundle.class);
    private static PrimerClient primerClient = null;

    public abstract PrimerBundleConfiguration getPrimerConfiguration(T var1);

    public abstract Set<String> withWhiteList(T var1);

    public abstract PrimerAuthorizationMatrix withAuthorization(T var1);

    public static PrimerClient getPrimerClient() {
        return primerClient;
    }

    public CuratorFramework getCurator(T configuration) {
        PrimerBundleConfiguration primerBundleConfiguration = this.getPrimerConfiguration(configuration);
        PrimerRangerEndpoint config = (PrimerRangerEndpoint)primerBundleConfiguration.getEndpoint();
        CuratorFramework curatorFramework = CuratorFrameworkFactory.builder().connectString(config.getZookeeper()).namespace(config.getNamespace()).retryPolicy((RetryPolicy)new RetryNTimes(1000, 500)).build();
        curatorFramework.start();
        return curatorFramework;
    }

    public void initialize(Bootstrap<?> bootstrap) {
        bootstrap.getObjectMapper().registerSubtypes(new NamedType[]{new NamedType(PrimerSimpleEndpoint.class, "simple")});
        bootstrap.getObjectMapper().registerSubtypes(new NamedType[]{new NamedType(PrimerRangerEndpoint.class, "ranger")});
    }

    public void run(T configuration, final Environment environment) throws Exception {
        final PrimerBundleConfiguration primerConfig = this.getPrimerConfiguration(configuration);
        this.initializeAuthorization(configuration);
        final JacksonDecoder decoder = new JacksonDecoder();
        final JacksonEncoder encoder = new JacksonEncoder();
        final Slf4jLogger logger = new Slf4jLogger();
        environment.lifecycle().manage(new Managed(){

            public void start() throws Exception {
                TokenCacheManager.init(primerConfig);
            }

            public void stop() throws Exception {
            }
        });
        environment.lifecycle().manage(new Managed((Configuration)configuration){
            final /* synthetic */ Configuration val$configuration;
            {
                this.val$configuration = configuration;
            }

            public void start() throws Exception {
                primerClient = (PrimerClient)Feign.builder().decoder((Decoder)decoder).encoder((Encoder)encoder).errorDecoder((methodKey, response) -> {
                    try {
                        PrimerError error = (PrimerError)environment.getObjectMapper().readValue(response.body().asInputStream(), PrimerError.class);
                        return PrimerException.builder().message(error.getMessage()).errorCode(error.getErrorCode()).status(response.status()).build();
                    }
                    catch (IOException e) {
                        return PrimerException.builder().status(response.status()).errorCode("PR000").message(e.getMessage()).build();
                    }
                }).client((Client)new OkHttpClient()).logger((feign.Logger)logger).logLevel(Logger.Level.BASIC).target(PrimerBundle.this.getPrimerTarget(this.val$configuration, environment));
            }

            public void stop() throws Exception {
            }
        });
        environment.jersey().register((Object)new PrimerExceptionMapper());
        DefaultJsonWebTokenParser tokenParser = new DefaultJsonWebTokenParser();
        byte[] secretKey = this.getPrimerConfiguration(configuration).getPrivateKey().getBytes(StandardCharsets.UTF_8);
        HmacSHA512Verifier tokenVerifier = new HmacSHA512Verifier(secretKey);
        environment.jersey().register((Object)PrimerAuthenticatorRequestFilter.builder().configuration(this.getPrimerConfiguration(configuration)).tokenParser((JsonWebTokenParser)tokenParser).verifier(tokenVerifier).objectMapper(environment.getObjectMapper()).build());
    }

    private Target<PrimerClient> getPrimerTarget(T configuration, Environment environment) {
        PrimerBundleConfiguration primerConfig = this.getPrimerConfiguration(configuration);
        switch (primerConfig.getEndpoint().getType()) {
            case "simple": {
                PrimerSimpleEndpoint endpoint = (PrimerSimpleEndpoint)primerConfig.getEndpoint();
                return new Target.HardCodedTarget(PrimerClient.class, String.format("http://%s:%d", endpoint.getHost(), endpoint.getPort()));
            }
            case "ranger": {
                PrimerRangerEndpoint config = (PrimerRangerEndpoint)primerConfig.getEndpoint();
                try {
                    return new RangerTarget(PrimerClient.class, config.getEnvironment(), config.getNamespace(), config.getService(), this.getCurator(configuration), false, environment.getObjectMapper());
                }
                catch (Exception e) {
                    log.error("Error creating ranger endpoint for primer", (Throwable)e);
                    return null;
                }
            }
        }
        throw new IllegalArgumentException("unknown primer target type specified");
    }

    private void initializeAuthorization(T configuration) {
        PrimerAuthorizationMatrix permissionMatrix;
        PrimerBundleConfiguration primerConfig = this.getPrimerConfiguration(configuration);
        HashSet<String> whiteListUrls = new HashSet<String>();
        Set<String> dynamicWhiteList = this.withWhiteList(configuration);
        if (dynamicWhiteList != null) {
            whiteListUrls.addAll(dynamicWhiteList);
        }
        if (primerConfig.getWhileListUrl() != null) {
            whiteListUrls.addAll(primerConfig.getWhileListUrl());
        }
        if ((permissionMatrix = primerConfig.getAuthorizations()) == null) {
            permissionMatrix = this.withAuthorization(configuration);
        } else {
            permissionMatrix.getAuthorizations().addAll(this.withAuthorization(configuration).getAuthorizations());
        }
        PrimerAuthorizationRegistry.init(permissionMatrix, whiteListUrls);
    }
}

