/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.primer.auth;

import com.github.toastshaman.dropwizard.auth.jwt.model.JsonWebToken;
import io.dropwizard.primer.PrimerBundle;
import io.dropwizard.primer.cache.TokenCacheManager;
import io.dropwizard.primer.core.ServiceUser;
import io.dropwizard.primer.core.VerifyResponse;
import io.dropwizard.primer.core.VerifyStaticResponse;
import io.dropwizard.primer.exception.PrimerException;
import io.dropwizard.primer.model.PrimerAuthorization;
import io.dropwizard.primer.model.PrimerAuthorizationMatrix;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrimerAuthorizationRegistry {
    private static final Logger log = LoggerFactory.getLogger(PrimerAuthorizationRegistry.class);
    private static Map<String, PrimerAuthorization> authList;
    private static List<String> whiteList;
    private static List<String> urlPatterns;

    public static void init(PrimerAuthorizationMatrix matrix, Set<String> whiteListUrls) {
        authList = new HashMap<String, PrimerAuthorization>();
        whiteList = new ArrayList<String>();
        urlPatterns = new ArrayList<String>();
        HashMap urlToAuthMap = new HashMap();
        Pattern tokenMatch = Pattern.compile("\\{(([^/])+\\})");
        if (matrix != null) {
            matrix.getAuthorizations().forEach(auth -> {
                String pattern = PrimerAuthorizationRegistry.generatePathExpression(auth.getUrl());
                urlPatterns.add(pattern);
                urlToAuthMap.put(pattern, auth);
            });
            matrix.getStaticAuthorizations().forEach(auth -> {
                String pattern = PrimerAuthorizationRegistry.generatePathExpression(auth.getUrl());
                urlPatterns.add(pattern);
                urlToAuthMap.put(pattern, auth);
            });
            Collections.sort(urlPatterns, (o1, o2) -> tokenMatch.matcher((CharSequence)o2).groupCount() - tokenMatch.matcher((CharSequence)o1).groupCount());
            Collections.sort(urlPatterns, (o1, o2) -> o2.compareTo((String)o1));
            urlPatterns.forEach(pattern -> authList.put((String)pattern, (PrimerAuthorization)urlToAuthMap.get(pattern)));
        }
        whiteListUrls.forEach(url -> whiteList.add(PrimerAuthorizationRegistry.generatePathExpression(url)));
        Collections.sort(whiteList, (o1, o2) -> tokenMatch.matcher((CharSequence)o2).groupCount() - tokenMatch.matcher((CharSequence)o1).groupCount());
    }

    private static String generatePathExpression(String path) {
        return path.replaceAll("\\{(([^/])+\\})", "(([^/])+)");
    }

    public static boolean authorize(String path, String role, String method, String token, JsonWebToken jsonWebToken) throws PrimerException {
        if (TokenCacheManager.checkCache(token)) {
            return true;
        }
        Optional<String> index = urlPatterns.stream().filter(path::matches).findFirst();
        if (!index.isPresent()) {
            return false;
        }
        if (!PrimerAuthorizationRegistry.isAuthorized(index.get(), method, role)) {
            return false;
        }
        switch (authList.get(index.get()).getType()) {
            case "dynamic": {
                return PrimerAuthorizationRegistry.verify(jsonWebToken, token, "dynamic");
            }
            case "static": {
                return PrimerAuthorizationRegistry.verify(jsonWebToken, token, "static");
            }
            case "auto": {
                String type = (String)jsonWebToken.claim().getParameter("type");
                return PrimerAuthorizationRegistry.verify(jsonWebToken, token, type);
            }
        }
        return false;
    }

    public static boolean isWhilisted(String path) {
        return whiteList.stream().filter(p -> path.startsWith((String)p) && path.matches((String)p)).findFirst().isPresent();
    }

    private static boolean isAuthorized(String id, String method, String role) {
        return authList.get(id).getRoles().contains(role) && authList.get(id).getMethods().contains(method);
    }

    private static boolean verify(JsonWebToken webToken, String token, String type) throws PrimerException {
        switch (type) {
            case "dynamic": {
                return PrimerAuthorizationRegistry.verify(webToken, token);
            }
            case "static": {
                return PrimerAuthorizationRegistry.verifyStatic(webToken, token);
            }
        }
        return false;
    }

    private static boolean verify(JsonWebToken webToken, String token) throws PrimerException {
        boolean result;
        VerifyResponse verifyResponse = PrimerBundle.getPrimerClient().verify(webToken.claim().issuer(), webToken.claim().subject(), token, ServiceUser.builder().id((String)webToken.claim().getParameter("user_id")).name((String)webToken.claim().getParameter("name")).role((String)webToken.claim().getParameter("role")).build());
        boolean bl = result = !StringUtils.isBlank((CharSequence)verifyResponse.getToken()) && !StringUtils.isBlank((CharSequence)verifyResponse.getUserId());
        if (result) {
            TokenCacheManager.cache(token);
        }
        return result;
    }

    private static boolean verifyStatic(JsonWebToken webToken, String token) throws PrimerException {
        boolean result;
        VerifyStaticResponse verifyStaticResponse = PrimerBundle.getPrimerClient().verify(webToken.claim().issuer(), webToken.claim().subject(), token, (String)webToken.claim().getParameter("role"));
        boolean bl = result = !StringUtils.isBlank((CharSequence)verifyStaticResponse.getToken()) && !StringUtils.isBlank((CharSequence)verifyStaticResponse.getId());
        if (result) {
            TokenCacheManager.cache(token);
        }
        return result;
    }
}

