/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.primer.cache;

import com.google.common.base.Optional;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.dropwizard.primer.model.PrimerBundleConfiguration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

public class TokenCacheManager {
    private static LoadingCache<String, Optional<Boolean>> blacklistCache;
    private static LoadingCache<String, Optional<Boolean>> lruCache;

    public static void init(PrimerBundleConfiguration configuration) {
        blacklistCache = CacheBuilder.newBuilder().concurrencyLevel(32).maximumSize((long)configuration.getCacheMaxSize()).expireAfterWrite((long)configuration.getCacheExpiry(), TimeUnit.SECONDS).recordStats().build((CacheLoader)new CacheLoader<String, Optional<Boolean>>(){

            public Optional<Boolean> load(String key) throws Exception {
                return Optional.of((Object)false);
            }
        });
        lruCache = CacheBuilder.newBuilder().concurrencyLevel(32).expireAfterWrite((long)configuration.getCacheExpiry(), TimeUnit.SECONDS).maximumSize((long)configuration.getCacheMaxSize()).recordStats().build((CacheLoader)new CacheLoader<String, Optional<Boolean>>(){

            public Optional<Boolean> load(String key) throws Exception {
                return Optional.of((Object)false);
            }
        });
    }

    public static void blackList(String token) {
        blacklistCache.put((Object)token, (Object)Optional.of((Object)true));
    }

    public static void cache(String token) {
        lruCache.put((Object)token, (Object)Optional.of((Object)true));
    }

    public static boolean checkCache(String token) {
        try {
            return (Boolean)((Optional)lruCache.get((Object)token)).get();
        }
        catch (ExecutionException e) {
            return false;
        }
    }

    public static boolean checkBlackList(String token) throws ExecutionException {
        return (Boolean)((Optional)blacklistCache.get((Object)token)).get();
    }
}

