/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.primer.auth.whitelist;

import io.dropwizard.primer.auth.annotation.AuthWhitelist;
import io.dropwizard.primer.auth.whitelist.WhitelistType;
import io.dropwizard.primer.util.IPAddressUtil;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class AuthWhitelistValidator
implements WhitelistType.Visitor<Boolean> {
    private final AuthWhitelist authWhitelist;
    private final HttpServletRequest httpServletRequest;

    public AuthWhitelistValidator(AuthWhitelist authWhitelist, HttpServletRequest httpServletRequest) {
        this.authWhitelist = authWhitelist;
        this.httpServletRequest = httpServletRequest;
    }

    @Override
    public Boolean visitOptional() {
        return Boolean.parseBoolean(this.authWhitelist.value()) && StringUtils.isNotBlank((CharSequence)this.httpServletRequest.getHeader("Authorization"));
    }

    @Override
    public Boolean visitIP() {
        return Arrays.asList(this.authWhitelist.value().split(",")).contains(IPAddressUtil.getIP(this.httpServletRequest));
    }

    public static AuthWhitelistValidatorBuilder builder() {
        return new AuthWhitelistValidatorBuilder();
    }

    public static class AuthWhitelistValidatorBuilder {
        private AuthWhitelist authWhitelist;
        private HttpServletRequest httpServletRequest;

        AuthWhitelistValidatorBuilder() {
        }

        public AuthWhitelistValidatorBuilder authWhitelist(AuthWhitelist authWhitelist) {
            this.authWhitelist = authWhitelist;
            return this;
        }

        public AuthWhitelistValidatorBuilder httpServletRequest(HttpServletRequest httpServletRequest) {
            this.httpServletRequest = httpServletRequest;
            return this;
        }

        public AuthWhitelistValidator build() {
            return new AuthWhitelistValidator(this.authWhitelist, this.httpServletRequest);
        }

        public String toString() {
            return "AuthWhitelistValidator.AuthWhitelistValidatorBuilder(authWhitelist=" + this.authWhitelist + ", httpServletRequest=" + this.httpServletRequest + ")";
        }
    }
}

