/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.primer.auth.filter;

import com.codahale.metrics.annotation.Metered;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.toastshaman.dropwizard.auth.jwt.model.JsonWebToken;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.dropwizard.primer.auth.AuthFilter;
import io.dropwizard.primer.auth.AuthType;
import io.dropwizard.primer.auth.annotation.AuthWhitelist;
import io.dropwizard.primer.auth.annotation.Authorize;
import io.dropwizard.primer.auth.authorizer.PrimerAnnotationAuthorizer;
import io.dropwizard.primer.auth.whitelist.AuthWhitelistValidator;
import io.dropwizard.primer.core.PrimerError;
import io.dropwizard.primer.exception.PrimerException;
import io.dropwizard.primer.model.PrimerBundleConfiguration;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.CompletionException;
import javax.annotation.Priority;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Priority(value=1000)
public class PrimerAuthAnnotationFilter
extends AuthFilter {
    private static final Logger log = LoggerFactory.getLogger(PrimerAuthAnnotationFilter.class);
    private final HttpServletRequest requestProxy;
    private final PrimerAnnotationAuthorizer authorizer;
    private final Authorize authorize;
    private final AuthWhitelist authWhitelist;

    public PrimerAuthAnnotationFilter(HttpServletRequest requestProxy, PrimerBundleConfiguration configuration, ObjectMapper objectMapper, Authorize authorize, PrimerAnnotationAuthorizer authorizer, AuthWhitelist authWhitelist) {
        super(AuthType.ANNOTATION, configuration, objectMapper);
        this.requestProxy = requestProxy;
        this.authorizer = authorizer;
        this.authorize = authorize;
        this.authWhitelist = authWhitelist;
    }

    @Metered(name="authorize")
    public void filter(ContainerRequestContext requestContext) throws IOException {
        if (!this.isEnabled() || this.isWhitelisted()) {
            return;
        }
        Optional<String> token = this.getToken(requestContext);
        if (!token.isPresent()) {
            requestContext.abortWith(Response.status((Response.Status)this.configuration.getAbsentTokenStatus()).entity((Object)this.objectMapper.writeValueAsBytes((Object)PrimerError.builder().errorCode("PR000").message("Bad request").build())).build());
        } else {
            try {
                JsonWebToken webToken = this.authorize(requestContext, token.get(), this.authType);
                if (this.authorizer != null) {
                    this.authorizer.authorize(webToken, requestContext, this.authorize);
                }
                this.stampHeaders(requestContext, webToken);
            }
            catch (UncheckedExecutionException e) {
                if (e.getCause() instanceof CompletionException) {
                    this.handleException(e.getCause().getCause(), requestContext, token.get());
                } else {
                    this.handleException(e.getCause(), requestContext, token.get());
                }
            }
            catch (Exception e) {
                if (e.getCause() instanceof PrimerException) {
                    this.handleException(e.getCause(), requestContext, token.get());
                }
                this.handleException(e, requestContext, token.get());
            }
        }
    }

    private boolean isEnabled() {
        return this.configuration.isEnabled() && this.configuration.getAuthTypesEnabled().getOrDefault((Object)AuthType.ANNOTATION, false) != false;
    }

    private boolean isWhitelisted() {
        return this.authWhitelist != null && this.authWhitelist.type().accept(new AuthWhitelistValidator(this.authWhitelist, this.requestProxy)) != false;
    }

    public static PrimerAuthAnnotationFilterBuilder builder() {
        return new PrimerAuthAnnotationFilterBuilder();
    }

    public static class PrimerAuthAnnotationFilterBuilder {
        private HttpServletRequest requestProxy;
        private PrimerBundleConfiguration configuration;
        private ObjectMapper objectMapper;
        private Authorize authorize;
        private PrimerAnnotationAuthorizer authorizer;
        private AuthWhitelist authWhitelist;

        PrimerAuthAnnotationFilterBuilder() {
        }

        public PrimerAuthAnnotationFilterBuilder requestProxy(HttpServletRequest requestProxy) {
            this.requestProxy = requestProxy;
            return this;
        }

        public PrimerAuthAnnotationFilterBuilder configuration(PrimerBundleConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public PrimerAuthAnnotationFilterBuilder objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            return this;
        }

        public PrimerAuthAnnotationFilterBuilder authorize(Authorize authorize) {
            this.authorize = authorize;
            return this;
        }

        public PrimerAuthAnnotationFilterBuilder authorizer(PrimerAnnotationAuthorizer authorizer) {
            this.authorizer = authorizer;
            return this;
        }

        public PrimerAuthAnnotationFilterBuilder authWhitelist(AuthWhitelist authWhitelist) {
            this.authWhitelist = authWhitelist;
            return this;
        }

        public PrimerAuthAnnotationFilter build() {
            return new PrimerAuthAnnotationFilter(this.requestProxy, this.configuration, this.objectMapper, this.authorize, this.authorizer, this.authWhitelist);
        }

        public String toString() {
            return "PrimerAuthAnnotationFilter.PrimerAuthAnnotationFilterBuilder(requestProxy=" + this.requestProxy + ", configuration=" + this.configuration + ", objectMapper=" + this.objectMapper + ", authorize=" + this.authorize + ", authorizer=" + this.authorizer + ", authWhitelist=" + this.authWhitelist + ")";
        }
    }
}

