/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.primer.auth;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.dropwizard.primer.auth.annotation.AuthWhitelist;
import io.dropwizard.primer.auth.annotation.Authorize;
import io.dropwizard.primer.auth.authorizer.PrimerAnnotationAuthorizer;
import io.dropwizard.primer.auth.filter.PrimerAuthAnnotationFilter;
import io.dropwizard.primer.model.PrimerBundleConfiguration;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.FeatureContext;
import javax.ws.rs.ext.Provider;

@Provider
public class PrimerAuthAnnotationFeature
implements DynamicFeature {
    @Context
    private HttpServletRequest requestProxy;
    private final PrimerBundleConfiguration configuration;
    private final ObjectMapper mapper;
    private final PrimerAnnotationAuthorizer authorizer;

    public PrimerAuthAnnotationFeature(PrimerBundleConfiguration configuration, ObjectMapper mapper, PrimerAnnotationAuthorizer authorizer) {
        this.configuration = configuration;
        this.mapper = mapper;
        this.authorizer = authorizer;
    }

    public void configure(ResourceInfo resourceInfo, FeatureContext featureContext) {
        Optional.ofNullable(resourceInfo.getResourceMethod()).map(resourceMethod -> resourceMethod.getAnnotation(Authorize.class)).ifPresent(authorize -> {
            FeatureContext cfr_ignored_0 = (FeatureContext)featureContext.register((Object)PrimerAuthAnnotationFilter.builder().requestProxy(this.requestProxy).configuration(this.configuration).objectMapper(this.mapper).authorize((Authorize)authorize).authorizer(this.authorizer).authWhitelist(resourceInfo.getResourceMethod().getAnnotation(AuthWhitelist.class)).build());
        });
    }

    public static PrimerAuthAnnotationFeatureBuilder builder() {
        return new PrimerAuthAnnotationFeatureBuilder();
    }

    public static class PrimerAuthAnnotationFeatureBuilder {
        private PrimerBundleConfiguration configuration;
        private ObjectMapper mapper;
        private PrimerAnnotationAuthorizer authorizer;

        PrimerAuthAnnotationFeatureBuilder() {
        }

        public PrimerAuthAnnotationFeatureBuilder configuration(PrimerBundleConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public PrimerAuthAnnotationFeatureBuilder mapper(ObjectMapper mapper) {
            this.mapper = mapper;
            return this;
        }

        public PrimerAuthAnnotationFeatureBuilder authorizer(PrimerAnnotationAuthorizer authorizer) {
            this.authorizer = authorizer;
            return this;
        }

        public PrimerAuthAnnotationFeature build() {
            return new PrimerAuthAnnotationFeature(this.configuration, this.mapper, this.authorizer);
        }

        public String toString() {
            return "PrimerAuthAnnotationFeature.PrimerAuthAnnotationFeatureBuilder(configuration=" + this.configuration + ", mapper=" + this.mapper + ", authorizer=" + this.authorizer + ")";
        }
    }
}

