/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.primer.model;

import io.dropwizard.primer.model.PrimerAuthorization;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class PrimerAuthorizationMatrix {
    List<PrimerAuthorization> staticAuthorizations;
    List<PrimerAuthorization> authorizations;
    List<PrimerAuthorization> autoAuthorizations;

    public static PrimerAuthorizationMatrixBuilder builder() {
        return new PrimerAuthorizationMatrixBuilder();
    }

    public List<PrimerAuthorization> getStaticAuthorizations() {
        return this.staticAuthorizations;
    }

    public List<PrimerAuthorization> getAuthorizations() {
        return this.authorizations;
    }

    public List<PrimerAuthorization> getAutoAuthorizations() {
        return this.autoAuthorizations;
    }

    public void setStaticAuthorizations(List<PrimerAuthorization> staticAuthorizations) {
        this.staticAuthorizations = staticAuthorizations;
    }

    public void setAuthorizations(List<PrimerAuthorization> authorizations) {
        this.authorizations = authorizations;
    }

    public void setAutoAuthorizations(List<PrimerAuthorization> autoAuthorizations) {
        this.autoAuthorizations = autoAuthorizations;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PrimerAuthorizationMatrix)) {
            return false;
        }
        PrimerAuthorizationMatrix other = (PrimerAuthorizationMatrix)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<PrimerAuthorization> this$staticAuthorizations = this.getStaticAuthorizations();
        List<PrimerAuthorization> other$staticAuthorizations = other.getStaticAuthorizations();
        if (this$staticAuthorizations == null ? other$staticAuthorizations != null : !((Object)this$staticAuthorizations).equals(other$staticAuthorizations)) {
            return false;
        }
        List<PrimerAuthorization> this$authorizations = this.getAuthorizations();
        List<PrimerAuthorization> other$authorizations = other.getAuthorizations();
        if (this$authorizations == null ? other$authorizations != null : !((Object)this$authorizations).equals(other$authorizations)) {
            return false;
        }
        List<PrimerAuthorization> this$autoAuthorizations = this.getAutoAuthorizations();
        List<PrimerAuthorization> other$autoAuthorizations = other.getAutoAuthorizations();
        return !(this$autoAuthorizations == null ? other$autoAuthorizations != null : !((Object)this$autoAuthorizations).equals(other$autoAuthorizations));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PrimerAuthorizationMatrix;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<PrimerAuthorization> $staticAuthorizations = this.getStaticAuthorizations();
        result = result * 59 + ($staticAuthorizations == null ? 43 : ((Object)$staticAuthorizations).hashCode());
        List<PrimerAuthorization> $authorizations = this.getAuthorizations();
        result = result * 59 + ($authorizations == null ? 43 : ((Object)$authorizations).hashCode());
        List<PrimerAuthorization> $autoAuthorizations = this.getAutoAuthorizations();
        result = result * 59 + ($autoAuthorizations == null ? 43 : ((Object)$autoAuthorizations).hashCode());
        return result;
    }

    public String toString() {
        return "PrimerAuthorizationMatrix(staticAuthorizations=" + this.getStaticAuthorizations() + ", authorizations=" + this.getAuthorizations() + ", autoAuthorizations=" + this.getAutoAuthorizations() + ")";
    }

    public PrimerAuthorizationMatrix() {
    }

    public PrimerAuthorizationMatrix(List<PrimerAuthorization> staticAuthorizations, List<PrimerAuthorization> authorizations, List<PrimerAuthorization> autoAuthorizations) {
        this.staticAuthorizations = staticAuthorizations;
        this.authorizations = authorizations;
        this.autoAuthorizations = autoAuthorizations;
    }

    public static class PrimerAuthorizationMatrixBuilder {
        private ArrayList<PrimerAuthorization> staticAuthorizations;
        private ArrayList<PrimerAuthorization> authorizations;
        private ArrayList<PrimerAuthorization> autoAuthorizations;

        PrimerAuthorizationMatrixBuilder() {
        }

        public PrimerAuthorizationMatrixBuilder staticAuthorization(PrimerAuthorization staticAuthorization) {
            if (this.staticAuthorizations == null) {
                this.staticAuthorizations = new ArrayList();
            }
            this.staticAuthorizations.add(staticAuthorization);
            return this;
        }

        public PrimerAuthorizationMatrixBuilder staticAuthorizations(Collection<? extends PrimerAuthorization> staticAuthorizations) {
            if (this.staticAuthorizations == null) {
                this.staticAuthorizations = new ArrayList();
            }
            this.staticAuthorizations.addAll(staticAuthorizations);
            return this;
        }

        public PrimerAuthorizationMatrixBuilder clearStaticAuthorizations() {
            if (this.staticAuthorizations != null) {
                this.staticAuthorizations.clear();
            }
            return this;
        }

        public PrimerAuthorizationMatrixBuilder authorization(PrimerAuthorization authorization) {
            if (this.authorizations == null) {
                this.authorizations = new ArrayList();
            }
            this.authorizations.add(authorization);
            return this;
        }

        public PrimerAuthorizationMatrixBuilder authorizations(Collection<? extends PrimerAuthorization> authorizations) {
            if (this.authorizations == null) {
                this.authorizations = new ArrayList();
            }
            this.authorizations.addAll(authorizations);
            return this;
        }

        public PrimerAuthorizationMatrixBuilder clearAuthorizations() {
            if (this.authorizations != null) {
                this.authorizations.clear();
            }
            return this;
        }

        public PrimerAuthorizationMatrixBuilder autoAuthorization(PrimerAuthorization autoAuthorization) {
            if (this.autoAuthorizations == null) {
                this.autoAuthorizations = new ArrayList();
            }
            this.autoAuthorizations.add(autoAuthorization);
            return this;
        }

        public PrimerAuthorizationMatrixBuilder autoAuthorizations(Collection<? extends PrimerAuthorization> autoAuthorizations) {
            if (this.autoAuthorizations == null) {
                this.autoAuthorizations = new ArrayList();
            }
            this.autoAuthorizations.addAll(autoAuthorizations);
            return this;
        }

        public PrimerAuthorizationMatrixBuilder clearAutoAuthorizations() {
            if (this.autoAuthorizations != null) {
                this.autoAuthorizations.clear();
            }
            return this;
        }

        public PrimerAuthorizationMatrix build() {
            List<PrimerAuthorization> autoAuthorizations;
            List<PrimerAuthorization> authorizations;
            List<PrimerAuthorization> staticAuthorizations;
            switch (this.staticAuthorizations == null ? 0 : this.staticAuthorizations.size()) {
                case 0: {
                    staticAuthorizations = Collections.emptyList();
                    break;
                }
                case 1: {
                    staticAuthorizations = Collections.singletonList(this.staticAuthorizations.get(0));
                    break;
                }
                default: {
                    staticAuthorizations = Collections.unmodifiableList(new ArrayList<PrimerAuthorization>(this.staticAuthorizations));
                }
            }
            switch (this.authorizations == null ? 0 : this.authorizations.size()) {
                case 0: {
                    authorizations = Collections.emptyList();
                    break;
                }
                case 1: {
                    authorizations = Collections.singletonList(this.authorizations.get(0));
                    break;
                }
                default: {
                    authorizations = Collections.unmodifiableList(new ArrayList<PrimerAuthorization>(this.authorizations));
                }
            }
            switch (this.autoAuthorizations == null ? 0 : this.autoAuthorizations.size()) {
                case 0: {
                    autoAuthorizations = Collections.emptyList();
                    break;
                }
                case 1: {
                    autoAuthorizations = Collections.singletonList(this.autoAuthorizations.get(0));
                    break;
                }
                default: {
                    autoAuthorizations = Collections.unmodifiableList(new ArrayList<PrimerAuthorization>(this.autoAuthorizations));
                }
            }
            return new PrimerAuthorizationMatrix(staticAuthorizations, authorizations, autoAuthorizations);
        }

        public String toString() {
            return "PrimerAuthorizationMatrix.PrimerAuthorizationMatrixBuilder(staticAuthorizations=" + this.staticAuthorizations + ", authorizations=" + this.authorizations + ", autoAuthorizations=" + this.autoAuthorizations + ")";
        }
    }
}

