/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.aeroapike;

import com.aerospike.client.AerospikeClient;
import com.aerospike.client.Host;
import com.aerospike.client.IAerospikeClient;
import com.aerospike.client.policy.ClientPolicy;
import com.aerospike.client.policy.ConsistencyLevel;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.policy.Replica;
import com.aerospike.client.policy.WritePolicy;
import com.google.common.base.Preconditions;
import io.dropwizard.revolver.core.config.AerospikeMailBoxConfig;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AerospikeConnectionManager {
    private static final Logger log = LoggerFactory.getLogger(AerospikeConnectionManager.class);
    private static IAerospikeClient client;
    private static AerospikeMailBoxConfig config;

    public static void init(AerospikeMailBoxConfig aerospikeConfig) {
        config = aerospikeConfig;
        Policy readPolicy = new Policy();
        readPolicy.maxRetries = config.getRetries();
        readPolicy.consistencyLevel = ConsistencyLevel.CONSISTENCY_ONE;
        readPolicy.replica = Replica.RANDOM;
        readPolicy.sleepBetweenRetries = config.getSleepBetweenRetries();
        readPolicy.timeout = config.getTimeout();
        WritePolicy writePolicy = new WritePolicy();
        writePolicy.maxRetries = config.getRetries();
        writePolicy.consistencyLevel = ConsistencyLevel.CONSISTENCY_ALL;
        writePolicy.replica = Replica.MASTER;
        writePolicy.sleepBetweenRetries = config.getSleepBetweenRetries();
        writePolicy.timeout = config.getTimeout();
        writePolicy.expiration = config.getTtl();
        ClientPolicy clientPolicy = new ClientPolicy();
        clientPolicy.maxConnsPerNode = config.getMaxConnectionsPerNode();
        clientPolicy.readPolicyDefault = readPolicy;
        clientPolicy.writePolicyDefault = writePolicy;
        clientPolicy.failIfNotConnected = true;
        String[] hosts = config.getHosts().split(",");
        List<Host> hostAddresses = Arrays.stream(hosts).map(h -> {
            String[] host = h.split(":");
            if (host.length == 2) {
                return new Host(host[0], Integer.parseInt(host[1]));
            }
            return new Host(host[0], 3000);
        }).collect(Collectors.toList());
        client = new AerospikeClient(clientPolicy, hostAddresses.toArray(new Host[0]));
        log.info("Aerospike connection status: " + client.isConnected());
    }

    public static IAerospikeClient getClient() {
        Preconditions.checkNotNull((Object)client);
        return client;
    }

    public static void setClient(IAerospikeClient aerospikeClient) {
        client = aerospikeClient;
    }

    public static void close() {
        if (null != client) {
            client.close();
        }
    }
}

