/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.core.util;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.HystrixThreadPoolProperties;
import io.dropwizard.revolver.core.RevolverCommand;
import io.dropwizard.revolver.core.RevolverExecutionException;
import io.dropwizard.revolver.core.config.CommandHandlerConfig;
import io.dropwizard.revolver.core.config.RevolverServiceConfig;
import io.dropwizard.revolver.core.config.RuntimeConfig;
import io.dropwizard.revolver.core.config.hystrix.CircuitBreakerConfig;
import io.dropwizard.revolver.core.config.hystrix.MetricsConfig;
import io.dropwizard.revolver.core.config.hystrix.ThreadPoolConfig;
import io.dropwizard.revolver.core.model.RevolverRequest;
import io.dropwizard.revolver.core.tracing.TraceInfo;

public class RevolverCommandHelper {
    public static String getName(RevolverRequest request) {
        return Joiner.on((String)".").join((Object)request.getService(), (Object)request.getApi(), new Object[0]);
    }

    public static <T extends RevolverRequest> T normalize(T request) {
        if (null == request) {
            throw new RevolverExecutionException(RevolverExecutionException.Type.BAD_REQUEST, "Request cannot be null");
        }
        TraceInfo traceInfo = request.getTrace();
        if (traceInfo == null) {
            traceInfo = new TraceInfo();
            request.setTrace(traceInfo);
        }
        if (Strings.isNullOrEmpty((String)traceInfo.getRequestId())) {
            throw new RevolverExecutionException(RevolverExecutionException.Type.BAD_REQUEST, "Request ID must be passed in span");
        }
        if (Strings.isNullOrEmpty((String)traceInfo.getTransactionId())) {
            throw new RevolverExecutionException(RevolverExecutionException.Type.BAD_REQUEST, "Transaction ID must be passed");
        }
        if (0L == traceInfo.getTimestamp()) {
            traceInfo.setTimestamp(System.currentTimeMillis());
        }
        return request;
    }

    public static HystrixCommand.Setter setter(RevolverCommand commandHandler, String api) {
        RuntimeConfig runtimeConfig = commandHandler.getRuntimeConfig();
        Object serviceConfiguration = commandHandler.getServiceConfiguration();
        CommandHandlerConfig config = (CommandHandlerConfig)commandHandler.getApiConfigurations().get(api);
        CircuitBreakerConfig circuitBreakerConfig = null != runtimeConfig ? runtimeConfig.getCircuitBreaker() : (null != config.getRuntime() && null != config.getRuntime().getCircuitBreaker() ? config.getRuntime().getCircuitBreaker() : (null != ((RevolverServiceConfig)serviceConfiguration).getRuntime() && null != ((RevolverServiceConfig)serviceConfiguration).getRuntime().getCircuitBreaker() ? ((RevolverServiceConfig)serviceConfiguration).getRuntime().getCircuitBreaker() : new CircuitBreakerConfig()));
        ThreadPoolConfig threadPoolConfig = null != runtimeConfig ? runtimeConfig.getThreadPool() : (null != ((RevolverServiceConfig)serviceConfiguration).getRuntime() && null != ((RevolverServiceConfig)serviceConfiguration).getRuntime().getThreadPool() ? ((RevolverServiceConfig)serviceConfiguration).getRuntime().getThreadPool() : new ThreadPoolConfig());
        MetricsConfig metricsConfig = null != runtimeConfig ? runtimeConfig.getMetrics() : new MetricsConfig();
        String keyName = Joiner.on((String)".").join((Object)((RevolverServiceConfig)commandHandler.getServiceConfiguration()).getService(), (Object)api, new Object[0]);
        return HystrixCommand.Setter.withGroupKey((HystrixCommandGroupKey)HystrixCommandGroupKey.Factory.asKey((String)((RevolverServiceConfig)serviceConfiguration).getService())).andCommandPropertiesDefaults(HystrixCommandProperties.Setter().withExecutionIsolationStrategy(threadPoolConfig.isSemaphoreIsolated() ? HystrixCommandProperties.ExecutionIsolationStrategy.SEMAPHORE : HystrixCommandProperties.ExecutionIsolationStrategy.THREAD).withExecutionIsolationSemaphoreMaxConcurrentRequests(threadPoolConfig.getConcurrency()).withFallbackIsolationSemaphoreMaxConcurrentRequests(threadPoolConfig.getConcurrency()).withFallbackEnabled(commandHandler.isFallbackEnabled()).withCircuitBreakerErrorThresholdPercentage(circuitBreakerConfig.getErrorThresholdPercentage()).withCircuitBreakerRequestVolumeThreshold(circuitBreakerConfig.getNumAcceptableFailuresInTimeWindow()).withCircuitBreakerSleepWindowInMilliseconds(circuitBreakerConfig.getWaitTimeBeforeRetry()).withExecutionTimeoutInMilliseconds(threadPoolConfig.getTimeout()).withMetricsHealthSnapshotIntervalInMilliseconds(metricsConfig.getHealthCheckInterval()).withMetricsRollingPercentileBucketSize(metricsConfig.getPercentileBucketSize()).withMetricsRollingPercentileWindowInMilliseconds(metricsConfig.getPercentileTimeInMillis())).andCommandKey(HystrixCommandKey.Factory.asKey((String)keyName)).andThreadPoolKey(HystrixThreadPoolKey.Factory.asKey((String)keyName)).andThreadPoolPropertiesDefaults(HystrixThreadPoolProperties.Setter().withCoreSize(threadPoolConfig.getConcurrency()).withMaxQueueSize(threadPoolConfig.getMaxRequestQueueSize()).withQueueSizeRejectionThreshold(threadPoolConfig.getDynamicRequestQueueSize()).withMetricsRollingStatisticalWindowBuckets(metricsConfig.getStatsBucketSize()).withMetricsRollingStatisticalWindowInMilliseconds(metricsConfig.getStatsTimeInMillis()));
    }
}

