/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.resource;

import com.codahale.metrics.annotation.Metered;
import io.dropwizard.revolver.base.core.RevolverCallbackRequest;
import io.dropwizard.revolver.base.core.RevolverCallbackResponse;
import io.dropwizard.revolver.base.core.RevolverRequestState;
import io.dropwizard.revolver.base.core.RevolverRequestStateResponse;
import io.dropwizard.revolver.exception.RevolverException;
import io.dropwizard.revolver.persistence.PersistenceProvider;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/revolver")
@Singleton
@Api(value="MailBox", description="Revolver gateway api for interacting mailbox requests")
public class RevolverMailboxResource {
    private static final Logger log = LoggerFactory.getLogger(RevolverMailboxResource.class);
    private PersistenceProvider persistenceProvider;
    private static final Map<String, String> notFound = Collections.singletonMap("message", "Request not found");
    private static final Map<String, String> error = Collections.singletonMap("message", "Server error");

    @Path(value="/v1/request/status/{requestId}")
    @GET
    @Metered
    @ApiOperation(value="Get the status of the request in the mailbox")
    public RevolverRequestStateResponse requestStatus(@PathParam(value="requestId") String requestId) throws RevolverException {
        try {
            RevolverRequestState state = this.persistenceProvider.requestState(requestId);
            if (state == null) {
                throw RevolverException.builder().status(Response.Status.NOT_FOUND.getStatusCode()).message("Not found").errorCode("R002").build();
            }
            return RevolverRequestStateResponse.builder().requestId(requestId).state(state.name()).build();
        }
        catch (Exception e) {
            log.error("Error getting request state", (Throwable)e);
            throw RevolverException.builder().status(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).errorCode("R001").message(ExceptionUtils.getRootCause((Throwable)e).getMessage()).build();
        }
    }

    @Path(value="/v1/request/ack/{requestId}")
    @POST
    @Metered
    @ApiOperation(value="Get the status of the request in the mailbox")
    public Response ack(@PathParam(value="requestId") String requestId) throws RevolverException {
        try {
            RevolverRequestState state = this.persistenceProvider.requestState(requestId);
            if (state == null) {
                throw RevolverException.builder().status(Response.Status.NOT_FOUND.getStatusCode()).message("Not found").errorCode("R002").build();
            }
            switch (state) {
                case RESPONDED: 
                case ERROR: {
                    this.persistenceProvider.setRequestState(requestId, RevolverRequestState.READ);
                    return Response.accepted().build();
                }
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (Exception e) {
            log.error("Error getting request state", (Throwable)e);
            throw RevolverException.builder().status(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).errorCode("R001").message(ExceptionUtils.getRootCause((Throwable)e).getMessage()).build();
        }
    }

    @Path(value="/v1/request/{requestId}")
    @GET
    @Metered
    @ApiOperation(value="Get the request in the mailbox")
    public RevolverCallbackRequest request(@PathParam(value="requestId") String requestId) throws RevolverException {
        try {
            RevolverCallbackRequest callbackRequest = this.persistenceProvider.request(requestId);
            if (callbackRequest == null) {
                throw RevolverException.builder().status(Response.Status.NOT_FOUND.getStatusCode()).message("Not found").errorCode("R002").build();
            }
            return callbackRequest;
        }
        catch (Exception e) {
            log.error("Error getting request", (Throwable)e);
            throw RevolverException.builder().status(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).errorCode("R001").message(ExceptionUtils.getRootCause((Throwable)e).getMessage()).build();
        }
    }

    @Path(value="/v1/response/{requestId}")
    @GET
    @Metered
    @ApiOperation(value="Get the request in the mailbox")
    public RevolverCallbackResponse response(@PathParam(value="requestId") String requestId) throws RevolverException {
        try {
            RevolverCallbackResponse callbackResponse = this.persistenceProvider.response(requestId);
            if (callbackResponse == null) {
                throw RevolverException.builder().status(Response.Status.NOT_FOUND.getStatusCode()).message("Not found").errorCode("R002").build();
            }
            return callbackResponse;
        }
        catch (Exception e) {
            log.error("Error getting response", (Throwable)e);
            throw RevolverException.builder().status(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).errorCode("R001").message(ExceptionUtils.getRootCause((Throwable)e).getMessage()).build();
        }
    }

    @Path(value="/v1/requests")
    @GET
    @Metered
    @ApiOperation(value="Get all the requests in the mailbox")
    public List<RevolverCallbackRequest> requests(@HeaderParam(value="X-MAILBOX-ID") String mailboxId) throws RevolverException {
        try {
            List<RevolverCallbackRequest> callbackRequests = this.persistenceProvider.requests(mailboxId);
            if (callbackRequests == null) {
                throw RevolverException.builder().status(Response.Status.NOT_FOUND.getStatusCode()).message("Not found").errorCode("R002").build();
            }
            return callbackRequests;
        }
        catch (Exception e) {
            log.error("Error getting requests", (Throwable)e);
            throw RevolverException.builder().status(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).errorCode("R001").message(ExceptionUtils.getRootCause((Throwable)e).getMessage()).build();
        }
    }

    @Path(value="/v1/responses")
    @GET
    @Metered
    @ApiOperation(value="Get all the responses in the mailbox")
    public List<RevolverCallbackResponse> responses(@HeaderParam(value="X-MAILBOX-ID") String mailboxId) throws RevolverException {
        try {
            List<RevolverCallbackResponse> callbackResponses = this.persistenceProvider.responses(mailboxId);
            if (callbackResponses == null) {
                throw RevolverException.builder().status(Response.Status.NOT_FOUND.getStatusCode()).message("Not found").errorCode("R002").build();
            }
            return callbackResponses;
        }
        catch (Exception e) {
            log.error("Error getting responses", (Throwable)e);
            throw RevolverException.builder().status(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).errorCode("R001").message(ExceptionUtils.getRootCause((Throwable)e).getMessage()).build();
        }
    }

    public static RevolverMailboxResourceBuilder builder() {
        return new RevolverMailboxResourceBuilder();
    }

    public PersistenceProvider getPersistenceProvider() {
        return this.persistenceProvider;
    }

    public void setPersistenceProvider(PersistenceProvider persistenceProvider) {
        this.persistenceProvider = persistenceProvider;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RevolverMailboxResource)) {
            return false;
        }
        RevolverMailboxResource other = (RevolverMailboxResource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PersistenceProvider this$persistenceProvider = this.getPersistenceProvider();
        PersistenceProvider other$persistenceProvider = other.getPersistenceProvider();
        return !(this$persistenceProvider == null ? other$persistenceProvider != null : !this$persistenceProvider.equals(other$persistenceProvider));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RevolverMailboxResource;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PersistenceProvider $persistenceProvider = this.getPersistenceProvider();
        result = result * 59 + ($persistenceProvider == null ? 43 : $persistenceProvider.hashCode());
        return result;
    }

    public String toString() {
        return "RevolverMailboxResource(persistenceProvider=" + this.getPersistenceProvider() + ")";
    }

    @ConstructorProperties(value={"persistenceProvider"})
    public RevolverMailboxResource(PersistenceProvider persistenceProvider) {
        this.persistenceProvider = persistenceProvider;
    }

    public static class RevolverMailboxResourceBuilder {
        private PersistenceProvider persistenceProvider;

        RevolverMailboxResourceBuilder() {
        }

        public RevolverMailboxResourceBuilder persistenceProvider(PersistenceProvider persistenceProvider) {
            this.persistenceProvider = persistenceProvider;
            return this;
        }

        public RevolverMailboxResource build() {
            return new RevolverMailboxResource(this.persistenceProvider);
        }

        public String toString() {
            return "RevolverMailboxResource.RevolverMailboxResourceBuilder(persistenceProvider=" + this.persistenceProvider + ")";
        }
    }
}

