/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.resource;

import com.codahale.metrics.annotation.Metered;
import com.google.common.base.Strings;
import com.google.common.io.ByteStreams;
import io.dropwizard.revolver.base.core.RevolverCallbackRequest;
import io.dropwizard.revolver.base.core.RevolverCallbackResponse;
import io.dropwizard.revolver.callback.CallbackHandler;
import io.dropwizard.revolver.persistence.PersistenceProvider;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/revolver")
@Singleton
@Api(value="RequestCallback", description="Revolver gateway api for callbacks on mailbox requests")
public class RevolverCallbackResource {
    private static final Logger log = LoggerFactory.getLogger(RevolverCallbackResource.class);
    private static final String RESPONSE_CODE_HEADER = "X-RESPONSE-CODE";
    private final PersistenceProvider persistenceProvider;
    private final CallbackHandler callbackHandler;

    public RevolverCallbackResource(PersistenceProvider persistenceProvider, CallbackHandler callbackHandler) {
        this.persistenceProvider = persistenceProvider;
        this.callbackHandler = callbackHandler;
    }

    @Path(value="/v1/callback/{requestId}")
    @POST
    @Metered
    @ApiOperation(value="Callback for updating responses for a given mailbox request")
    @Produces(value={"application/json", "application/msgpack", "application/xml"})
    @Consumes(value={"application/json", "application/msgpack", "application/xml"})
    public Response handleCallback(@PathParam(value="requestId") String requestId, @HeaderParam(value="X-RESPONSE-CODE") String responseCode, @Context HttpHeaders headers, @Context HttpServletRequest request) {
        try {
            RevolverCallbackRequest callbackRequest = this.persistenceProvider.request(requestId);
            if (callbackRequest == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            RevolverCallbackResponse response = RevolverCallbackResponse.builder().body(ByteStreams.toByteArray((InputStream)request.getInputStream())).headers((Map<String, List<String>>)headers.getRequestHeaders()).statusCode(responseCode != null ? Integer.parseInt(responseCode) : Response.Status.OK.getStatusCode()).build();
            this.persistenceProvider.saveResponse(requestId, response);
            if (callbackRequest.getMode() != null && callbackRequest.getMode().equals("CALLBACK") && !Strings.isNullOrEmpty((String)callbackRequest.getCallbackUri())) {
                this.callbackHandler.handle(requestId);
            }
            return Response.accepted().build();
        }
        catch (Exception e) {
            log.error("Callback error", (Throwable)e);
            return Response.serverError().build();
        }
    }
}

