/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.core;

import com.google.common.base.Stopwatch;
import com.google.common.base.Strings;
import com.netflix.hystrix.HystrixCommand;
import io.dropwizard.revolver.core.RevolverContext;
import io.dropwizard.revolver.core.RevolverExecutionException;
import io.dropwizard.revolver.core.config.ClientConfig;
import io.dropwizard.revolver.core.config.CommandHandlerConfig;
import io.dropwizard.revolver.core.config.RevolverServiceConfig;
import io.dropwizard.revolver.core.config.RuntimeConfig;
import io.dropwizard.revolver.core.model.RevolverRequest;
import io.dropwizard.revolver.core.model.RevolverResponse;
import io.dropwizard.revolver.core.tracing.Trace;
import io.dropwizard.revolver.core.tracing.TraceCollector;
import io.dropwizard.revolver.core.tracing.TraceInfo;
import io.dropwizard.revolver.core.util.RevolverCommandHelper;
import io.dropwizard.revolver.core.util.RevolverExceptionHelper;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.slf4j.MDC;

public abstract class RevolverCommand<RequestType extends RevolverRequest, ResponseType extends RevolverResponse, ContextType extends RevolverContext, ServiceConfigurationType extends RevolverServiceConfig, CommandHandlerConfigType extends CommandHandlerConfig> {
    private final ContextType context;
    private final RuntimeConfig runtimeConfig;
    private final ServiceConfigurationType serviceConfiguration;
    private final Map<String, CommandHandlerConfigType> apiConfigurations;
    private final TraceCollector traceCollector;
    private ClientConfig clientConfiguration;

    public RevolverCommand(ContextType context, ClientConfig clientConfiguration, RuntimeConfig runtimeConfig, ServiceConfigurationType serviceConfiguration, Map<String, CommandHandlerConfigType> apiConfigurations, TraceCollector traceCollector) {
        this.context = context;
        this.clientConfiguration = clientConfiguration;
        this.runtimeConfig = runtimeConfig;
        this.serviceConfiguration = serviceConfiguration;
        this.apiConfigurations = apiConfigurations;
        this.traceCollector = traceCollector;
    }

    public ResponseType execute(RequestType request) throws RevolverExecutionException {
        RevolverResponse revolverResponse;
        CommandHandlerConfig apiConfiguration = (CommandHandlerConfig)this.apiConfigurations.get(((RevolverRequest)request).getApi());
        if (null == apiConfiguration) {
            throw new RevolverExecutionException(RevolverExecutionException.Type.BAD_REQUEST, "No api spec defined for key: " + ((RevolverRequest)request).getApi());
        }
        RequestType normalizedRequest = RevolverCommandHelper.normalize(request);
        TraceInfo traceInfo = ((RevolverRequest)normalizedRequest).getTrace();
        this.addContextInfo(request, traceInfo);
        Stopwatch watch = Stopwatch.createStarted();
        String errorMessage = null;
        try {
            revolverResponse = (RevolverResponse)new RevolverCommandHandler(RevolverCommandHelper.setter(this, ((RevolverRequest)request).getApi()), this.context, this, normalizedRequest).execute();
            this.publishTrace(Trace.builder().caller(this.clientConfiguration.getClientName()).service(((RevolverServiceConfig)this.serviceConfiguration).getService()).api(apiConfiguration.getApi()).duration(watch.stop().elapsed(TimeUnit.MILLISECONDS)).transactionId(traceInfo.getTransactionId()).requestId(traceInfo.getRequestId()).parentRequestId(traceInfo.getParentRequestId()).timestamp(traceInfo.getTimestamp()).attributes(traceInfo.getAttributes()).error(!Strings.isNullOrEmpty((String)errorMessage)).errorReason(errorMessage).build());
        }
        catch (Throwable t) {
            try {
                errorMessage = t.getLocalizedMessage();
                throw new RevolverExecutionException(RevolverExecutionException.Type.SERVICE_ERROR, t);
            }
            catch (Throwable throwable) {
                this.publishTrace(Trace.builder().caller(this.clientConfiguration.getClientName()).service(((RevolverServiceConfig)this.serviceConfiguration).getService()).api(apiConfiguration.getApi()).duration(watch.stop().elapsed(TimeUnit.MILLISECONDS)).transactionId(traceInfo.getTransactionId()).requestId(traceInfo.getRequestId()).parentRequestId(traceInfo.getParentRequestId()).timestamp(traceInfo.getTimestamp()).attributes(traceInfo.getAttributes()).error(!Strings.isNullOrEmpty((String)errorMessage)).errorReason(errorMessage).build());
                throw throwable;
            }
        }
        return (ResponseType)revolverResponse;
    }

    private void addContextInfo(RequestType request, TraceInfo traceInfo) {
        MDC.put((String)"command", (String)RevolverCommandHelper.getName(request));
        MDC.put((String)"transactionId", (String)traceInfo.getTransactionId());
        MDC.put((String)"requestId", (String)traceInfo.getRequestId());
        MDC.put((String)"parentRequestId", (String)traceInfo.getParentRequestId());
    }

    public CompletableFuture<ResponseType> executeAsync(RequestType request) {
        RequestType normalizedRequest = RevolverCommandHelper.normalize(request);
        TraceInfo traceInfo = ((RevolverRequest)normalizedRequest).getTrace();
        this.addContextInfo(request, traceInfo);
        Stopwatch watch = Stopwatch.createStarted();
        Future responseFuture = new RevolverCommandHandler(RevolverCommandHelper.setter(this, ((RevolverRequest)request).getApi()), this.context, this, normalizedRequest).queue();
        return CompletableFuture.supplyAsync(() -> {
            RevolverResponse revolverResponse;
            String errorMessage = null;
            try {
                revolverResponse = (RevolverResponse)responseFuture.get();
                this.publishTrace(Trace.builder().caller(this.clientConfiguration.getClientName()).service(((RevolverServiceConfig)this.serviceConfiguration).getService()).api(request.getApi()).duration(watch.stop().elapsed(TimeUnit.MILLISECONDS)).transactionId(traceInfo.getTransactionId()).requestId(traceInfo.getRequestId()).parentRequestId(traceInfo.getParentRequestId()).timestamp(traceInfo.getTimestamp()).attributes(traceInfo.getAttributes()).error(!Strings.isNullOrEmpty((String)errorMessage)).errorReason(errorMessage).build());
            }
            catch (Throwable t) {
                try {
                    errorMessage = RevolverExceptionHelper.getLeafErrorMessage(t);
                    throw new RevolverExecutionException(RevolverExecutionException.Type.SERVICE_ERROR, String.format("Error executing command %s", RevolverCommandHelper.getName(request)), RevolverExceptionHelper.getLeafThrowable(t));
                }
                catch (Throwable throwable) {
                    this.publishTrace(Trace.builder().caller(this.clientConfiguration.getClientName()).service(((RevolverServiceConfig)this.serviceConfiguration).getService()).api(request.getApi()).duration(watch.stop().elapsed(TimeUnit.MILLISECONDS)).transactionId(traceInfo.getTransactionId()).requestId(traceInfo.getRequestId()).parentRequestId(traceInfo.getParentRequestId()).timestamp(traceInfo.getTimestamp()).attributes(traceInfo.getAttributes()).error(!Strings.isNullOrEmpty((String)errorMessage)).errorReason(errorMessage).build());
                    this.removeContextInfo();
                    throw throwable;
                }
            }
            this.removeContextInfo();
            return revolverResponse;
        });
    }

    private void publishTrace(Trace build) {
        this.traceCollector.publish(build);
    }

    private void removeContextInfo() {
        MDC.remove((String)"command");
        MDC.remove((String)"requestId");
        MDC.remove((String)"transactionId");
        MDC.remove((String)"parentRequestId");
    }

    public boolean isFallbackEnabled() {
        return true;
    }

    protected abstract ResponseType execute(ContextType var1, RequestType var2) throws Exception;

    protected abstract ResponseType fallback(ContextType var1, RequestType var2);

    protected ClientConfig getClientConfiguration() {
        return this.clientConfiguration;
    }

    public RuntimeConfig getRuntimeConfig() {
        return this.runtimeConfig;
    }

    public ServiceConfigurationType getServiceConfiguration() {
        return this.serviceConfiguration;
    }

    public Map<String, CommandHandlerConfigType> getApiConfigurations() {
        return this.apiConfigurations;
    }

    private static class RevolverCommandHandler<RequestType extends RevolverRequest, ResponseType extends RevolverResponse, ContextType extends RevolverContext, ServiceConfigurationType extends RevolverServiceConfig, CommandHandlerConfigurationType extends CommandHandlerConfig>
    extends HystrixCommand<ResponseType> {
        private final RevolverCommand<RequestType, ResponseType, ContextType, ServiceConfigurationType, CommandHandlerConfigurationType> handler;
        private final RequestType request;
        private final ContextType context;

        RevolverCommandHandler(HystrixCommand.Setter setter, ContextType context, RevolverCommand<RequestType, ResponseType, ContextType, ServiceConfigurationType, CommandHandlerConfigurationType> handler, RequestType request) {
            super(setter);
            this.context = context;
            this.handler = handler;
            this.request = request;
        }

        protected ResponseType run() throws Exception {
            return this.handler.execute(this.context, this.request);
        }

        protected ResponseType getFallback() {
            return this.handler.fallback(this.context, this.request);
        }
    }
}

