/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.persistence;

import io.dropwizard.revolver.base.core.RevolverCallbackRequest;
import io.dropwizard.revolver.base.core.RevolverCallbackResponse;
import io.dropwizard.revolver.base.core.RevolverRequestState;
import io.dropwizard.revolver.persistence.PersistenceProvider;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.inject.Singleton;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.lang3.StringUtils;

@Singleton
public class InMemoryPersistenceProvider
implements PersistenceProvider {
    private final ConcurrentHashMap<String, RevolverCallbackRequest> callbackRequests = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, RevolverCallbackResponse> callbackResponse = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, RevolverRequestState> callbackStates = new ConcurrentHashMap();
    private final MultivaluedMap<String, String> mailbox = new MultivaluedHashMap();

    @Override
    public boolean exists(String requestId) {
        return this.callbackRequests.containsKey(requestId);
    }

    @Override
    public void saveRequest(String requestId, String mailBoxId, RevolverCallbackRequest request) {
        this.callbackRequests.put(requestId, request);
        if (!StringUtils.isBlank((CharSequence)mailBoxId)) {
            this.mailbox.add((Object)mailBoxId, (Object)requestId);
        }
        this.callbackStates.put(requestId, RevolverRequestState.RECEIVED);
    }

    @Override
    public void setRequestState(String requestId, RevolverRequestState state) {
        this.callbackStates.put(requestId, state);
    }

    @Override
    public void saveResponse(String requestId, RevolverCallbackResponse response) {
        this.callbackResponse.put(requestId, response);
        this.callbackStates.put(requestId, RevolverRequestState.RESPONDED);
    }

    @Override
    public RevolverRequestState requestState(String requestId) {
        return this.callbackStates.get(requestId);
    }

    @Override
    public RevolverCallbackRequest request(String requestId) {
        return this.callbackRequests.get(requestId);
    }

    @Override
    public RevolverCallbackResponse response(String requestId) {
        return this.callbackResponse.get(requestId);
    }

    @Override
    public List<RevolverCallbackRequest> requests(String mailboxId) {
        List requestIds = (List)this.mailbox.get((Object)mailboxId);
        if (requestIds == null || requestIds.isEmpty()) {
            return Collections.emptyList();
        }
        return requestIds.stream().filter(this.callbackRequests::containsKey).map(this.callbackRequests::get).collect(Collectors.toList());
    }

    @Override
    public List<RevolverCallbackResponse> responses(String mailboxId) {
        List requestIds = (List)this.mailbox.get((Object)mailboxId);
        if (requestIds == null || requestIds.isEmpty()) {
            return Collections.emptyList();
        }
        return requestIds.stream().filter(this.callbackResponse::containsKey).map(this.callbackResponse::get).collect(Collectors.toList());
    }
}

