/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.revolver.core.model;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.dropwizard.revolver.core.tracing.TraceInfo;
import java.beans.ConstructorProperties;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.NotEmpty;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type", visible=true)
public class RevolverRequest {
    @NotNull
    @NotEmpty
    private String type;
    @NotNull
    @NotEmpty
    private String service;
    @NotNull
    @NotEmpty
    private String api;
    @NotNull
    @Valid
    private TraceInfo trace = new TraceInfo();

    public static RevolverRequestBuilder requestBuilder() {
        return new RevolverRequestBuilder();
    }

    public String getType() {
        return this.type;
    }

    public String getService() {
        return this.service;
    }

    public String getApi() {
        return this.api;
    }

    public TraceInfo getTrace() {
        return this.trace;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setService(String service) {
        this.service = service;
    }

    public void setApi(String api) {
        this.api = api;
    }

    public void setTrace(TraceInfo trace) {
        this.trace = trace;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RevolverRequest)) {
            return false;
        }
        RevolverRequest other = (RevolverRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$service = this.getService();
        String other$service = other.getService();
        if (this$service == null ? other$service != null : !this$service.equals(other$service)) {
            return false;
        }
        String this$api = this.getApi();
        String other$api = other.getApi();
        if (this$api == null ? other$api != null : !this$api.equals(other$api)) {
            return false;
        }
        TraceInfo this$trace = this.getTrace();
        TraceInfo other$trace = other.getTrace();
        return !(this$trace == null ? other$trace != null : !((Object)this$trace).equals(other$trace));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RevolverRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $service = this.getService();
        result = result * 59 + ($service == null ? 43 : $service.hashCode());
        String $api = this.getApi();
        result = result * 59 + ($api == null ? 43 : $api.hashCode());
        TraceInfo $trace = this.getTrace();
        result = result * 59 + ($trace == null ? 43 : ((Object)$trace).hashCode());
        return result;
    }

    public String toString() {
        return "RevolverRequest(type=" + this.getType() + ", service=" + this.getService() + ", api=" + this.getApi() + ", trace=" + this.getTrace() + ")";
    }

    @ConstructorProperties(value={"type", "service", "api", "trace"})
    public RevolverRequest(String type, String service, String api, TraceInfo trace) {
        this.type = type;
        this.service = service;
        this.api = api;
        this.trace = trace;
    }

    public RevolverRequest() {
    }

    public static class RevolverRequestBuilder {
        private String type;
        private String service;
        private String api;
        private TraceInfo trace;

        RevolverRequestBuilder() {
        }

        public RevolverRequestBuilder type(String type) {
            this.type = type;
            return this;
        }

        public RevolverRequestBuilder service(String service) {
            this.service = service;
            return this;
        }

        public RevolverRequestBuilder api(String api) {
            this.api = api;
            return this;
        }

        public RevolverRequestBuilder trace(TraceInfo trace) {
            this.trace = trace;
            return this;
        }

        public RevolverRequest build() {
            return new RevolverRequest(this.type, this.service, this.api, this.trace);
        }

        public String toString() {
            return "RevolverRequest.RevolverRequestBuilder(type=" + this.type + ", service=" + this.service + ", api=" + this.api + ", trace=" + this.trace + ")";
        }
    }
}

